/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPService;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ApplicationSettings;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.credential.store.credential.CommunityUser;
import org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential;
import org.apache.airavata.credential.store.notifier.NotifierBootstrap;
import org.apache.airavata.credential.store.notifier.impl.EmailNotifierConfiguration;
import org.apache.airavata.credential.store.store.impl.CertificateCredentialWriter;
import org.apache.airavata.credential.store.util.ConfigurationReader;
import org.apache.airavata.credential.store.util.PrivateKeyStore;
import org.apache.airavata.credential.store.util.Utility;

public class CredentialStoreCallbackServlet
extends ClientServlet {
    private OA4MPService oa4mpService;
    private CertificateCredentialWriter certificateCredentialWriter;
    private static ConfigurationReader configurationReader;
    private NotifierBootstrap notifierBootstrap;

    public void init() throws ServletException {
        DBUtil dbUtil;
        try {
            dbUtil = DBUtil.getCredentialStoreDBUtil();
        }
        catch (Exception e) {
            throw new ServletException("Error initializing database operations.", (Throwable)e);
        }
        try {
            configurationReader = new ConfigurationReader();
            super.init();
            this.certificateCredentialWriter = new CertificateCredentialWriter(dbUtil);
        }
        catch (Exception e) {
            throw new ServletException("Error initializing configuration reader.", (Throwable)e);
        }
        try {
            boolean enabled = Boolean.parseBoolean(ApplicationSettings.getCredentialStoreNotifierEnabled());
            if (enabled) {
                EmailNotifierConfiguration notifierConfiguration = EmailNotifierConfiguration.getEmailNotifierConfigurations();
                long duration = Long.parseLong(ApplicationSettings.getCredentialStoreNotifierDuration());
                this.notifierBootstrap = new NotifierBootstrap(duration, dbUtil, notifierConfiguration);
            }
        }
        catch (ApplicationSettingsException e) {
            throw new ServletException("Error initializing notifier.", (Throwable)e);
        }
        this.info("Credential store callback initialized successfully.");
    }

    public OA4MPService getOA4MPService() {
        return this.oa4mpService;
    }

    public void loadEnvironment() throws IOException {
        environment = CredentialStoreCallbackServlet.getConfigurationLoader().load();
        this.oa4mpService = new OA4MPService((ClientEnvironment)environment);
    }

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        X509Certificate[] certificates;
        PrivateKey privateKey;
        String gatewayName = request.getParameter("gatewayName");
        String portalUserName = request.getParameter("portalUserName");
        String durationParameter = request.getParameter("duration");
        String contactEmail = request.getParameter("email");
        String portalTokenId = request.getParameter("associatedToken");
        long duration = 864000L;
        if (durationParameter != null) {
            duration = Long.parseLong(durationParameter);
        }
        if (portalTokenId == null) {
            this.error("Token given by portal is invalid.");
            GeneralException ge = new GeneralException("Error: The token presented by portal is null.");
            request.setAttribute("exception", (Object)ge);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getErrorUrl());
            return;
        }
        this.info("Gateway name " + gatewayName);
        this.info("Portal user name " + portalUserName);
        this.info("Community user contact email " + contactEmail);
        this.info("Token id presented " + portalTokenId);
        this.info("2.a. Getting token and verifier.");
        String token = request.getParameter(CredentialStoreCallbackServlet.CONST((String)"oa4mp:token"));
        String verifier = request.getParameter(CredentialStoreCallbackServlet.CONST((String)"oa4mp:verifier"));
        if (token == null || verifier == null) {
            this.warn("2.a. The token is " + (token == null ? "null" : token) + " and the verifier is " + (verifier == null ? "null" : verifier));
            GeneralException ge = new GeneralException("Error: This servlet requires parameters for the token and verifier. It cannot be called directly.");
            request.setAttribute("exception", (Object)ge);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getErrorUrl());
            return;
        }
        this.info("2.a Token and verifier found.");
        AssetResponse assetResponse = null;
        try {
            PrivateKeyStore privateKeyStore = PrivateKeyStore.getPrivateKeyStore();
            privateKey = privateKeyStore.getKey(portalTokenId);
            if (privateKey != null) {
                this.info("Found private key for token " + portalTokenId);
            } else {
                this.info("Could not find private key for token " + portalTokenId);
            }
            this.info("2.a. Getting the cert(s) from the service");
            assetResponse = this.getOA4MPService().getCert(token, verifier);
            certificates = assetResponse.getX509Certificates();
        }
        catch (Throwable t) {
            this.warn("2.a. Exception from the server: " + t.getCause().getMessage());
            this.error("Exception while trying to get cert. message:" + t.getMessage());
            request.setAttribute("exception", (Object)t);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getErrorUrl());
            return;
        }
        this.info("2.b. Done! Displaying success page.");
        CertificateCredential certificateCredential = new CertificateCredential();
        certificateCredential.setNotBefore(Utility.convertDateToString(certificates[0].getNotBefore()));
        certificateCredential.setNotAfter(Utility.convertDateToString(certificates[0].getNotAfter()));
        certificateCredential.setCertificates(certificates);
        certificateCredential.setPrivateKey(privateKey);
        certificateCredential.setCommunityUser(new CommunityUser(gatewayName, assetResponse.getUsername(), contactEmail));
        certificateCredential.setPortalUserName(portalUserName);
        certificateCredential.setLifeTime(duration);
        certificateCredential.setToken(portalTokenId);
        this.certificateCredentialWriter.writeCredentials(certificateCredential);
        StringBuilder stringBuilder = new StringBuilder("Certificate for community user ");
        stringBuilder.append(assetResponse.getUsername()).append(" successfully persisted.");
        stringBuilder.append(" Certificate DN - ").append(certificates[0].getSubjectDN());
        this.info(stringBuilder.toString());
        if (this.isUrlInSameServer(configurationReader.getSuccessUrl())) {
            String contextPath = request.getContextPath();
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
            request.setAttribute("action", (Object)contextPath);
            request.setAttribute("tokenId", (Object)portalTokenId);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getSuccessUrl());
        } else {
            String urlToRedirect = this.decorateUrlWithToken(configurationReader.getSuccessUrl(), portalTokenId);
            this.info("Redirecting to url - " + urlToRedirect);
            response.sendRedirect(urlToRedirect);
        }
        this.info("2.a. Completely finished with delegation.");
    }

    private boolean isUrlInSameServer(String url) {
        return !url.toLowerCase().startsWith("http") && !url.toLowerCase().startsWith("https");
    }

    private String decorateUrlWithToken(String url, String tokenId) {
        StringBuilder stringBuilder = new StringBuilder(url);
        stringBuilder.append("?tokenId=").append(tokenId);
        return stringBuilder.toString();
    }

    private Map<String, String> createQueryParameters(String gatewayName, String portalUserName, String portalEmail, String tokenId) {
        String callbackUriKey = (String)CredentialStoreCallbackServlet.getEnvironment().getConstants().get("oa4mp:callback_uri");
        ClientEnvironment clientEnvironment = (ClientEnvironment)CredentialStoreCallbackServlet.getEnvironment();
        String callbackUri = clientEnvironment.getCallback().toString();
        StringBuilder stringBuilder = new StringBuilder(callbackUri);
        stringBuilder.append("?").append("gatewayName").append("=").append(gatewayName).append("&").append("portalUserName").append("=").append(portalUserName).append("&").append("email").append("=").append(portalEmail).append("&").append("associatedToken").append("=").append(tokenId);
        this.info("Callback URI is set to - " + stringBuilder.toString());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(callbackUriKey, stringBuilder.toString());
        return parameters;
    }
}

