/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.CredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.provider.KeyStoreParametersFactory;
import org.globus.gsi.stores.AbstractResourceSecurityWrapper;
import org.globus.gsi.stores.CertKeyCredential;
import org.globus.gsi.stores.CredentialWrapper;
import org.globus.gsi.stores.ResourceCACertStore;
import org.globus.gsi.stores.ResourceProxyCredential;
import org.globus.gsi.stores.ResourceProxyCredentialStore;
import org.globus.gsi.stores.ResourceSecurityWrapperStore;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.stores.ResourceTrustAnchor;
import org.globus.gsi.stores.SecurityObjectWrapper;
import org.globus.gsi.stores.Storable;
import org.globus.gsi.util.CertificateIOUtil;
import org.globus.util.GlobusPathMatchingResourcePatternResolver;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEMKeyStore
extends KeyStoreSpi {
    public static final String DEFAULT_DIRECTORY_KEY = "default_directory";
    public static final String DIRECTORY_LIST_KEY = "directory_list";
    public static final String CERTIFICATE_FILENAME = "certificateFilename";
    public static final String KEY_FILENAME = "keyFilename";
    public static final String PROXY_FILENAME = "proxyFilename";
    private static Log logger = LogFactory.getLog((String)PEMKeyStore.class.getCanonicalName());
    private Map<String, SecurityObjectWrapper<?>> aliasObjectMap = new Hashtable();
    private Map<Certificate, String> certFilenameMap = new HashMap<Certificate, String>();
    private File defaultDirectory;
    private ResourceSecurityWrapperStore<ResourceTrustAnchor, TrustAnchor> caDelegate = new ResourceCACertStore();
    private ResourceSecurityWrapperStore<ResourceProxyCredential, X509Credential> proxyDelegate = new ResourceProxyCredentialStore();
    private boolean inMemoryOnly = false;

    public void setCACertStore(ResourceSecurityWrapperStore<ResourceTrustAnchor, TrustAnchor> caCertStore) {
        this.caDelegate = caCertStore;
    }

    public void setProxyDelegate(ResourceSecurityWrapperStore<ResourceProxyCredential, X509Credential> proxyDelegate) {
        this.proxyDelegate = proxyDelegate;
    }

    private CredentialWrapper getKeyEntry(String alias) {
        SecurityObjectWrapper<?> object = this.aliasObjectMap.get(alias);
        if (object != null && object instanceof CredentialWrapper) {
            return (CredentialWrapper)object;
        }
        return null;
    }

    private ResourceTrustAnchor getCertificateEntry(String alias) {
        SecurityObjectWrapper<?> object = this.aliasObjectMap.get(alias);
        if (object != null && object instanceof ResourceTrustAnchor) {
            return (ResourceTrustAnchor)object;
        }
        return null;
    }

    @Override
    public Key engineGetKey(String s, char[] chars) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        CredentialWrapper credential = this.getKeyEntry(s);
        PrivateKey key = null;
        if (credential != null) {
            try {
                String password = null;
                if (chars != null) {
                    password = new String(chars);
                }
                key = credential.getCredential().getPrivateKey(password);
            }
            catch (ResourceStoreException e) {
                throw new UnrecoverableKeyException(e.getMessage());
            }
            catch (CredentialException e) {
                throw new UnrecoverableKeyException(e.getMessage());
            }
        }
        return key;
    }

    @Override
    public boolean engineIsKeyEntry(String s) {
        return this.getKeyEntry(s) != null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] chars) throws IOException, NoSuchAlgorithmException, CertificateException {
        for (SecurityObjectWrapper<?> object : this.aliasObjectMap.values()) {
            if (!(object instanceof Storable)) continue;
            try {
                ((Storable)((Object)object)).store();
            }
            catch (ResourceStoreException e) {
                throw new CertificateException(e);
            }
        }
    }

    @Override
    public Date engineGetCreationDate(String s) {
        try {
            ResourceTrustAnchor trustAnchor = this.getCertificateEntry(s);
            if (trustAnchor != null) {
                return trustAnchor.getTrustAnchor().getTrustedCert().getNotBefore();
            }
            CredentialWrapper credential = this.getKeyEntry(s);
            if (credential != null) {
                return credential.getCredential().getNotBefore();
            }
        }
        catch (ResourceStoreException e) {
            return null;
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        return this.certFilenameMap.get(certificate);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String s) {
        CredentialWrapper credential = this.getKeyEntry(s);
        Certificate[] chain = new X509Certificate[]{};
        if (credential != null) {
            try {
                chain = credential.getCredential().getCertificateChain();
            }
            catch (ResourceStoreException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                chain = null;
            }
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String s) {
        ResourceTrustAnchor trustAnchor = this.getCertificateEntry(s);
        if (trustAnchor != null) {
            try {
                return trustAnchor.getTrustAnchor().getTrustedCert();
            }
            catch (ResourceStoreException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (!(loadStoreParameter instanceof KeyStoreParametersFactory.FileStoreParameters)) {
            throw new IllegalArgumentException("Unable to process parameters: " + loadStoreParameter);
        }
        KeyStoreParametersFactory.FileStoreParameters params = (KeyStoreParametersFactory.FileStoreParameters)loadStoreParameter;
        String defaultDirectoryString = (String)params.getProperty(DEFAULT_DIRECTORY_KEY);
        String directoryListString = (String)params.getProperty(DIRECTORY_LIST_KEY);
        String certFilename = (String)params.getProperty(CERTIFICATE_FILENAME);
        String keyFilename = (String)params.getProperty(KEY_FILENAME);
        String proxyFilename = (String)params.getProperty(PROXY_FILENAME);
        this.initialize(defaultDirectoryString, directoryListString, proxyFilename, certFilename, keyFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream inputStream, char[] chars) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            Properties properties = new Properties();
            if (inputStream != null) {
                properties.load(inputStream);
                if (properties.size() == 0) {
                    throw new CertificateException("Properties file for configuration was empty?");
                }
            } else if (chars == null) {
                this.inMemoryOnly = true;
            }
            String defaultDirectoryString = properties.getProperty(DEFAULT_DIRECTORY_KEY);
            String directoryListString = properties.getProperty(DIRECTORY_LIST_KEY);
            String proxyFilename = properties.getProperty(PROXY_FILENAME);
            String certFilename = properties.getProperty(CERTIFICATE_FILENAME);
            String keyFilename = properties.getProperty(KEY_FILENAME);
            this.initialize(defaultDirectoryString, directoryListString, proxyFilename, certFilename, keyFilename);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.info((Object)"Error closing inputStream", (Throwable)e);
                }
            }
        }
    }

    private void initialize(String defaultDirectoryString, String directoryListString, String proxyFilename, String certFilename, String keyFilename) throws IOException, CertificateException {
        if (defaultDirectoryString != null) {
            boolean directoryMade;
            this.defaultDirectory = new GlobusPathMatchingResourcePatternResolver().getResource(defaultDirectoryString).getFile();
            if (!this.defaultDirectory.exists() && !(directoryMade = this.defaultDirectory.mkdirs())) {
                throw new IOException("Unable to create default certificate directory");
            }
            this.loadDirectories(defaultDirectoryString);
        }
        if (directoryListString != null) {
            this.loadDirectories(directoryListString);
        }
        try {
            if (proxyFilename != null && proxyFilename.length() > 0) {
                this.loadProxyCertificate(proxyFilename);
            }
            if (certFilename != null && certFilename.length() > 0 && keyFilename != null && keyFilename.length() > 0) {
                this.loadCertificateKey(certFilename, keyFilename);
            }
        }
        catch (ResourceStoreException e) {
            throw new CertificateException(e);
        }
        catch (CredentialException e) {
            e.printStackTrace();
            throw new CertificateException(e);
        }
    }

    private void loadProxyCertificate(String proxyFilename) throws ResourceStoreException {
        if (proxyFilename == null) {
            return;
        }
        this.proxyDelegate.loadWrappers(proxyFilename);
        Map<String, ResourceProxyCredential> wrapperMap = this.proxyDelegate.getWrapperMap();
        for (ResourceProxyCredential credential : wrapperMap.values()) {
            this.aliasObjectMap.put(proxyFilename, credential);
        }
    }

    private void loadCertificateKey(String userCertFilename, String userKeyFilename) throws CredentialException, ResourceStoreException {
        GlobusPathMatchingResourcePatternResolver resolver = new GlobusPathMatchingResourcePatternResolver();
        if (userCertFilename == null || userKeyFilename == null) {
            return;
        }
        GlobusResource certResource = resolver.getResource(userCertFilename);
        GlobusResource keyResource = resolver.getResource(userKeyFilename);
        CertKeyCredential credential = new CertKeyCredential(certResource, keyResource);
        String alias = userCertFilename + ":" + userKeyFilename;
        this.aliasObjectMap.put(alias, credential);
    }

    private void loadDirectories(String directoryList) throws CertificateException {
        try {
            String alias;
            this.caDelegate.loadWrappers(directoryList);
            Map<String, ResourceTrustAnchor> wrapperMap = this.caDelegate.getWrapperMap();
            HashSet<String> knownCerts = new HashSet<String>();
            HashMap<String, String> ignoredAlias = new HashMap<String, String>();
            HashMap<String, ResourceTrustAnchor> ignoredAnchor = new HashMap<String, ResourceTrustAnchor>();
            HashMap<String, X509Certificate> ignoredCert = new HashMap<String, X509Certificate>();
            for (ResourceTrustAnchor trustAnchor : wrapperMap.values()) {
                boolean hash_in_alias;
                alias = trustAnchor.getResourceURL().toExternalForm();
                TrustAnchor tmpTrustAnchor = trustAnchor.getTrustAnchor();
                X509Certificate trustCert = tmpTrustAnchor.getTrustedCert();
                String hash = CertificateIOUtil.nameHash(trustCert.getSubjectX500Principal());
                if (this.aliasObjectMap == null) {
                    System.out.println("Alias Map Null");
                }
                boolean bl = hash_in_alias = !alias.contains(hash);
                if (knownCerts.contains(hash) || !hash_in_alias) {
                    if (hash_in_alias) continue;
                    ignoredAlias.put(hash, alias);
                    ignoredAnchor.put(hash, trustAnchor);
                    ignoredCert.put(hash, trustCert);
                    continue;
                }
                knownCerts.add(hash);
                this.aliasObjectMap.put(alias, trustAnchor);
                this.certFilenameMap.put(trustCert, alias);
            }
            for (String hash : ignoredAlias.keySet()) {
                if (knownCerts.contains(hash)) continue;
                alias = (String)ignoredAlias.get(hash);
                this.aliasObjectMap.put(alias, (SecurityObjectWrapper<?>)ignoredAnchor.get(hash));
                this.certFilenameMap.put((Certificate)ignoredCert.get(hash), alias);
            }
        }
        catch (ResourceStoreException e) {
            throw new CertificateException("", e);
        }
    }

    @Override
    public void engineDeleteEntry(String s) throws KeyStoreException {
        SecurityObjectWrapper<?> object = this.aliasObjectMap.remove(s);
        if (object != null) {
            if (object instanceof ResourceTrustAnchor) {
                X509Certificate cert;
                ResourceTrustAnchor descriptor = (ResourceTrustAnchor)object;
                try {
                    cert = descriptor.getTrustAnchor().getTrustedCert();
                }
                catch (ResourceStoreException e) {
                    throw new KeyStoreException(e);
                }
                this.certFilenameMap.remove(cert);
                boolean success = descriptor.getFile().delete();
                if (!success) {
                    logger.info((Object)"Unable to delete certificate");
                }
            } else if (object instanceof ResourceProxyCredential) {
                ResourceProxyCredential proxy = (ResourceProxyCredential)object;
                try {
                    proxy.getCredential();
                }
                catch (ResourceStoreException e) {
                    throw new KeyStoreException(e);
                }
                boolean success = proxy.getFile().delete();
                if (!success) {
                    logger.info((Object)"Unable to delete credential");
                }
            }
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.aliasObjectMap.keySet());
    }

    @Override
    public void engineSetKeyEntry(String s, Key key, char[] chars, Certificate[] certificates) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("PrivateKey expected");
        }
        if (!(certificates instanceof X509Certificate[])) {
            throw new KeyStoreException("Certificate chain of X509Certificate expected");
        }
        X509Credential credential = new X509Credential((PrivateKey)key, (X509Certificate[])certificates);
        CredentialWrapper wrapper = credential.isEncryptedKey() ? this.createCertKeyCredential(s, credential) : this.createProxyCredential(s, credential);
        this.storeWrapper(wrapper);
        this.aliasObjectMap.put(wrapper.getAlias(), wrapper);
    }

    private CredentialWrapper createProxyCredential(String s, X509Credential credential) throws KeyStoreException {
        ResourceProxyCredential wrapper;
        File file;
        CredentialWrapper proxyCredential = this.getKeyEntry(s);
        if (proxyCredential != null && proxyCredential instanceof AbstractResourceSecurityWrapper) {
            AbstractResourceSecurityWrapper proxyWrapper = (AbstractResourceSecurityWrapper)((Object)proxyCredential);
            file = proxyWrapper.getFile();
        } else {
            file = new File(this.defaultDirectory, s + "-key.pem");
        }
        try {
            wrapper = new ResourceProxyCredential(this.inMemoryOnly, new GlobusResource(file.getAbsolutePath()), credential);
        }
        catch (ResourceStoreException e) {
            throw new KeyStoreException(e);
        }
        return wrapper;
    }

    private CredentialWrapper createCertKeyCredential(String s, X509Credential credential) throws KeyStoreException {
        CertKeyCredential wrapper;
        GlobusResource keyResource;
        GlobusResource certResource;
        CredentialWrapper credentialWrapper = this.getKeyEntry(s);
        if (credentialWrapper != null && credentialWrapper instanceof CertKeyCredential) {
            CertKeyCredential certKeyCred = (CertKeyCredential)credentialWrapper;
            certResource = certKeyCred.getCertificateFile();
            keyResource = certKeyCred.getKeyFile();
        } else {
            certResource = new GlobusResource(new File(this.defaultDirectory, s + ".0").getAbsolutePath());
            keyResource = new GlobusResource(new File(this.defaultDirectory, s + "-key.pem").getAbsolutePath());
        }
        try {
            wrapper = new CertKeyCredential(certResource, keyResource, credential);
        }
        catch (ResourceStoreException e) {
            throw new KeyStoreException(e);
        }
        return wrapper;
    }

    private void storeWrapper(CredentialWrapper wrapper) throws KeyStoreException {
        if (!this.inMemoryOnly) {
            try {
                wrapper.store();
            }
            catch (ResourceStoreException e) {
                throw new KeyStoreException("Error storing credential", e);
            }
        }
    }

    @Override
    public void engineSetKeyEntry(String s, byte[] bytes, Certificate[] certificates) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean engineContainsAlias(String s) {
        return this.aliasObjectMap.containsKey(s);
    }

    @Override
    public int engineSize() {
        return this.aliasObjectMap.size();
    }

    @Override
    public boolean engineIsCertificateEntry(String s) {
        return this.getCertificateEntry(s) != null;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate certificate) throws KeyStoreException {
        if (!(certificate instanceof X509Certificate)) {
            throw new KeyStoreException("Certificate must be instance of X509Certificate");
        }
        ResourceTrustAnchor trustAnchor = this.getCertificateEntry(alias);
        File file = trustAnchor != null ? trustAnchor.getFile() : new File(this.defaultDirectory, alias);
        X509Certificate x509Cert = (X509Certificate)certificate;
        try {
            if (!this.inMemoryOnly) {
                CertificateIOUtil.writeCertificate(x509Cert, file);
            }
            ResourceTrustAnchor anchor = new ResourceTrustAnchor(this.inMemoryOnly, new GlobusResource(file.getAbsolutePath()), new TrustAnchor(x509Cert, null));
            this.aliasObjectMap.put(alias, anchor);
            this.certFilenameMap.put(x509Cert, alias);
        }
        catch (ResourceStoreException e) {
            throw new KeyStoreException(e);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e);
        }
    }
}

