/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.airavata.common.exception.AiravataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserLauncher {
    private static final String ERROR_MESSAGE = "Error while attempting to launch web browser";
    private static Logger logger = LoggerFactory.getLogger(BrowserLauncher.class);

    public static void openURL(URL url) throws AiravataException {
        BrowserLauncher.openURL(url.toString());
    }

    public static void openURL(String url) throws AiravataException {
        logger.debug("Enter:" + url);
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> macUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                Method openURL = macUtils.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "mozilla", "netscape", "opera", "konqueror"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new AiravataException("Could not find web browser.");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (ClassNotFoundException e) {
            throw new AiravataException(ERROR_MESSAGE, e);
        }
        catch (NoSuchMethodException e) {
            throw new AiravataException(ERROR_MESSAGE, e);
        }
        catch (IllegalAccessException e) {
            throw new AiravataException(ERROR_MESSAGE, e);
        }
        catch (InvocationTargetException e) {
            throw new AiravataException(ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new AiravataException(ERROR_MESSAGE, e);
        }
        catch (InterruptedException e) {
            throw new AiravataException(ERROR_MESSAGE, e);
        }
        catch (RuntimeException e) {
            throw new AiravataException(ERROR_MESSAGE, e);
        }
    }
}

