/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ssl;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ssl.SSLContextFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class BasicSSLContextFactory
implements SSLContextFactory {
    SSLContext sslContext;

    @Override
    public void init(Properties properties) throws Exception {
        String keyStore;
        KeyStore ks = KeyStore.getInstance("JKS");
        KeyStore ts = KeyStore.getInstance("JKS");
        String keyStorePassword = properties.getProperty("keyStorePassword");
        if (keyStorePassword == null) {
            keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if ((keyStore = properties.getProperty("keyStore")) == null) {
            keyStore = System.getProperty("javax.net.ssl.keyStore");
        }
        if (keyStore == null || keyStorePassword == null) {
            throw new RuntimeException("SSL is enabled but keyStore[Password] properties aren't set!");
        }
        String keyManagerAlgorithm = BasicSSLContextFactory.getProperty(properties, "keyManagerAlgorithm", "SunX509");
        String trustManagerAlgorithm = BasicSSLContextFactory.getProperty(properties, "trustManagerAlgorithm", "SunX509");
        String protocol = BasicSSLContextFactory.getProperty(properties, "protocol", "TLS");
        char[] passPhrase = keyStorePassword.toCharArray();
        String keyStoreFile = keyStore;
        this.loadKeyStore(ks, passPhrase, keyStoreFile);
        this.loadKeyStore(ts, passPhrase, keyStoreFile);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        kmf.init(ks, passPhrase);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        tmf.init(ts);
        this.sslContext = SSLContext.getInstance(protocol);
        this.sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyStore(KeyStore ks, char[] passPhrase, String keyStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException {
        FileInputStream in = new FileInputStream(keyStoreFile);
        try {
            ks.load(in, passPhrase);
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    private static String getProperty(Properties properties, String propertyName, String defaultValue) {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }
}

