/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.MultiMapOperationFactory;
import com.hazelcast.collection.operations.client.CollectionAllPartitionRequest;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.util.Map;

public class ContainsEntryRequest
extends CollectionAllPartitionRequest
implements RetryableRequest {
    Data key;
    Data value;

    public ContainsEntryRequest() {
    }

    public ContainsEntryRequest(CollectionProxyId proxyId, Data key, Data value) {
        super(proxyId);
        this.key = key;
        this.value = value;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.CONTAINS, this.key, this.value);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        for (Object obj : map.values()) {
            if (!Boolean.TRUE.equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        ObjectDataOutput out = writer.getRawDataOutput();
        IOUtil.writeNullableData(out, this.key);
        IOUtil.writeNullableData(out, this.value);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        ObjectDataInput in = reader.getRawDataInput();
        this.key = IOUtil.readNullableData(in);
        this.value = IOUtil.readNullableData(in);
        super.readPortable(reader);
    }
}

