/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.CollectionBackupAwareOperation;
import com.hazelcast.collection.operations.SetBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.List;

public class SetOperation
extends CollectionBackupAwareOperation {
    int index;
    Data value;
    transient long recordId;
    transient boolean shouldBackup;

    public SetOperation() {
    }

    public SetOperation(CollectionProxyId proxyId, Data dataKey, int threadId, int index, Data value) {
        super(proxyId, dataKey, threadId);
        this.index = index;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer container = this.getOrCreateContainer();
        this.recordId = container.nextId();
        CollectionRecord record = new CollectionRecord(this.recordId, this.isBinary() ? this.value : this.toObject(this.value));
        List list = (List)container.getOrCreateCollectionWrapper(this.dataKey).getCollection();
        try {
            record = list.set(this.index, record);
            this.response = record == null ? null : record.getObject();
            this.shouldBackup = true;
        }
        catch (IndexOutOfBoundsException e) {
            this.response = e;
        }
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.proxyId, this.dataKey, this.recordId, this.index, this.value);
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public int getId() {
        return 24;
    }
}

