/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.model.messaging.event.ExperimentSubmitEvent;
import org.apache.airavata.model.messaging.event.Message;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentConsumer
extends QueueingConsumer {
    private static final Logger log = LoggerFactory.getLogger(ExperimentConsumer.class);
    private MessageHandler handler;
    private Channel channel;
    private Connection connection;

    public ExperimentConsumer(MessageHandler messageHandler, Connection connection, Channel channel) {
        super(channel);
        this.handler = messageHandler;
        this.connection = connection;
        this.channel = channel;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        Message message = new Message();
        try {
            ThriftUtils.createThriftFromBytes((byte[])body, (TBase)message);
            long deliveryTag = envelope.getDeliveryTag();
            if (message.getMessageType() == MessageType.EXPERIMENT || message.getMessageType() == MessageType.EXPERIMENT_CANCEL) {
                ExperimentSubmitEvent event = null;
                String gatewayId = null;
                ExperimentSubmitEvent experimentEvent = new ExperimentSubmitEvent();
                ThriftUtils.createThriftFromBytes((byte[])message.getEvent(), (TBase)experimentEvent);
                log.info(" Message Received with message id '" + message.getMessageId() + "' and with message type '" + message.getMessageType() + "'  for experimentId: " + experimentEvent.getExperimentId());
                event = experimentEvent;
                gatewayId = experimentEvent.getGatewayId();
                MessageContext messageContext = new MessageContext((TBase)event, message.getMessageType(), message.getMessageId(), gatewayId, deliveryTag);
                messageContext.setUpdatedTime(AiravataUtils.getTime((long)message.getUpdatedTime()));
                messageContext.setIsRedeliver(envelope.isRedeliver());
                this.handler.onMessage(messageContext);
            } else {
                log.error("{} message type is not handle in ProcessLaunch Subscriber. Sending ack for delivery tag {} ", (Object)message.getMessageType().name(), (Object)deliveryTag);
                this.sendAck(deliveryTag);
            }
        }
        catch (TException e) {
            String msg = "Failed to de-serialize the thrift message, from routing keys:" + envelope.getRoutingKey();
            log.warn(msg, (Throwable)e);
        }
    }

    private void sendAck(long deliveryTag) {
        try {
            if (this.channel.isOpen()) {
                this.channel.basicAck(deliveryTag, false);
            } else {
                this.channel = this.connection.createChannel();
                this.channel.basicQos(ServerSettings.getRabbitmqPrefetchCount());
                this.channel.basicAck(deliveryTag, false);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

