/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.KeyStoreBuilder;
import org.apache.commons.ssl.TrustMaterial;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.X509CertificateChainBuilder;

public class KeyMaterial
extends TrustMaterial {
    private final Object keyManagerFactory;
    private final String alias;
    private final X509Certificate[] associatedChain;

    public KeyMaterial(InputStream jks, char[] password) throws GeneralSecurityException, IOException {
        this(Util.streamToBytes(jks), password);
    }

    public KeyMaterial(InputStream jks, InputStream key, char[] password) throws GeneralSecurityException, IOException {
        this(jks != null ? Util.streamToBytes(jks) : null, key != null ? Util.streamToBytes(key) : null, password);
    }

    public KeyMaterial(String pathToJksFile, char[] password) throws GeneralSecurityException, IOException {
        this(new File(pathToJksFile), password);
    }

    public KeyMaterial(String pathToCerts, String pathToKey, char[] password) throws GeneralSecurityException, IOException {
        this(pathToCerts != null ? new File(pathToCerts) : null, pathToKey != null ? new File(pathToKey) : null, password);
    }

    public KeyMaterial(File jksFile, char[] password) throws GeneralSecurityException, IOException {
        this(new FileInputStream(jksFile), password);
    }

    public KeyMaterial(File certsFile, File keyFile, char[] password) throws GeneralSecurityException, IOException {
        this(certsFile != null ? new FileInputStream(certsFile) : null, keyFile != null ? new FileInputStream(keyFile) : null, password);
    }

    public KeyMaterial(URL urlToJKS, char[] password) throws GeneralSecurityException, IOException {
        this(urlToJKS.openStream(), password);
    }

    public KeyMaterial(URL urlToCerts, URL urlToKey, char[] password) throws GeneralSecurityException, IOException {
        this(urlToCerts.openStream(), urlToKey.openStream(), password);
    }

    public KeyMaterial(byte[] jks, char[] password) throws GeneralSecurityException, IOException {
        this(jks, null, password);
    }

    public KeyMaterial(byte[] jksOrCerts, byte[] key, char[] password) throws GeneralSecurityException, IOException {
        super(KeyStoreBuilder.build(jksOrCerts, key, password), 0);
        Certificate[] chain;
        KeyStore ks = this.getKeyStore();
        Enumeration<String> en = ks.aliases();
        String myAlias = null;
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            if (myAlias != null) {
                throw new KeyStoreException("commons-ssl KeyMaterial only supports keystores with a single private key.");
            }
            myAlias = alias;
        }
        if (myAlias != null) {
            chain = ks.getCertificateChain(myAlias);
            if (chain == null) {
                throw new KeyStoreException("Could not find KeyMaterial's associated certificate chain!");
            }
        } else {
            throw new KeyStoreException("KeyMaterial provided does not contain any keys!");
        }
        Certificate[] myChain = Certificates.x509ifyChain(chain);
        this.alias = myAlias;
        if (myChain != null) {
            myChain = X509CertificateChainBuilder.buildPath(myChain[0], myChain);
        }
        this.associatedChain = myChain;
        this.keyManagerFactory = JavaImpl.newKeyManagerFactory(ks, password);
    }

    public Object[] getKeyManagers() {
        return JavaImpl.getKeyManagers(this.keyManagerFactory);
    }

    public X509Certificate[] getAssociatedCertificateChain() {
        return this.associatedChain;
    }

    public KeyStore getKeyStore() {
        return super.getKeyStore();
    }

    public String getAlias() {
        return this.alias;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage1:  java org.apache.commons.ssl.KeyMaterial [password] [pkcs12 or jks]");
            System.out.println("Usage2:  java org.apache.commons.ssl.KeyMaterial [password] [private-key] [cert-chain]");
            System.exit(1);
        }
        char[] password = args[0].toCharArray();
        String path1 = args[1];
        String path2 = null;
        if (args.length >= 3) {
            path2 = args[2];
        }
        KeyMaterial km = new KeyMaterial(path1, path2, password);
        System.out.println(km);
    }

    public String toString() {
        X509Certificate[] certs = this.getAssociatedCertificateChain();
        StringBuffer buf = new StringBuffer(1024);
        buf.append("Alias: ");
        buf.append(this.alias);
        buf.append('\n');
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                buf.append(Certificates.toString(certs[i]));
                try {
                    buf.append(Certificates.toPEMString(certs[i]));
                    continue;
                }
                catch (CertificateEncodingException cee) {
                    buf.append(cee.toString());
                    buf.append('\n');
                }
            }
        }
        return buf.toString();
    }
}

