/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.client;

import org.apache.airavata.service.profile.iam.admin.services.cpi.IamAdminServices;
import org.apache.airavata.service.profile.iam.admin.services.cpi.exception.IamAdminServicesException;
import org.apache.airavata.service.profile.tenant.cpi.TenantProfileService;
import org.apache.airavata.service.profile.tenant.cpi.exception.TenantProfileServiceException;
import org.apache.airavata.service.profile.user.cpi.UserProfileService;
import org.apache.airavata.service.profile.user.cpi.exception.UserProfileServiceException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ProfileServiceClientFactory {
    public static UserProfileService.Client createUserProfileServiceClient(String serverHost, int serverPort) throws UserProfileServiceException {
        try {
            TSocket transport = new TSocket(serverHost, serverPort);
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            TMultiplexedProtocol multiplexedProtocol = new TMultiplexedProtocol((TProtocol)protocol, "UserProfileService");
            return new UserProfileService.Client((TProtocol)multiplexedProtocol);
        }
        catch (TTransportException e) {
            throw new UserProfileServiceException(e.getMessage());
        }
    }

    public static TenantProfileService.Client createTenantProfileServiceClient(String serverHost, int serverPort) throws TenantProfileServiceException {
        try {
            TSocket transport = new TSocket(serverHost, serverPort);
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            TMultiplexedProtocol multiplexedProtocol = new TMultiplexedProtocol((TProtocol)protocol, "TenantProfileService");
            return new TenantProfileService.Client((TProtocol)multiplexedProtocol);
        }
        catch (TTransportException e) {
            throw new TenantProfileServiceException(e.getMessage());
        }
    }

    public static IamAdminServices.Client createIamAdminServiceClient(String serverHost, int serverPort) throws IamAdminServicesException {
        try {
            TSocket transport = new TSocket(serverHost, serverPort);
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            TMultiplexedProtocol multiplexedProtocol = new TMultiplexedProtocol((TProtocol)protocol, "IamAdminServices");
            return new IamAdminServices.Client((TProtocol)multiplexedProtocol);
        }
        catch (TTransportException e) {
            throw new IamAdminServicesException(e.getMessage());
        }
    }
}

