/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;
import java.io.IOException;

public abstract class CollectionBackupAwareOperation
extends CollectionKeyBasedOperation
implements BackupAwareOperation,
WaitSupport {
    protected int threadId = -1;

    protected CollectionBackupAwareOperation() {
    }

    protected CollectionBackupAwareOperation(CollectionProxyId proxyId, Data dataKey, int threadId) {
        super(proxyId, dataKey);
        this.threadId = threadId;
    }

    @Override
    public boolean shouldBackup() {
        return this.response != null;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.threadId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.threadId = in.readInt();
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:collectionService", this.proxyId), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        return !this.getOrCreateContainer().canAcquireLock(this.dataKey, this.getCallerUuid(), this.threadId);
    }

    @Override
    public long getWaitTimeoutMillis() {
        return -1L;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }
}

