/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceServlet
implements Servlet {
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String ETAG = "ETag";
    private String internalName;
    private ServletConfig config;

    public ResourceServlet() {
        this.internalName = "";
    }

    public ResourceServlet(String internalName) {
        this.internalName = internalName;
        if (internalName == null || internalName.equals("/")) {
            this.internalName = "";
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        String baseName = config.getInitParameter("base-name");
        if (baseName != null) {
            this.internalName = baseName.equals("/") ? "" : baseName;
        }
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        HttpServletResponse httpResponse = (HttpServletResponse)resp;
        String method = httpRequest.getMethod();
        if (method.equals("GET") || method.equals("POST") || method.equals("HEAD")) {
            String resourcePath = this.internalName + httpRequest.getPathInfo();
            if (!this.writeResource(httpRequest, httpResponse, resourcePath)) {
                httpResponse.setStatus(404);
            }
        } else {
            httpResponse.setStatus(405);
        }
    }

    public void destroy() {
        this.config = null;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeResource(HttpServletRequest req, HttpServletResponse resp, String resourcePath) throws IOException {
        String contentType;
        String ifNoneMatch;
        ServletContext servletContext = this.config.getServletContext();
        URL url = servletContext.getResource(resourcePath);
        if (url == null) {
            return false;
        }
        URLConnection connection = url.openConnection();
        long lastModified = connection.getLastModified();
        int contentLength = connection.getContentLength();
        String etag = null;
        if (lastModified != -1L && contentLength != -1) {
            etag = "W/\"" + contentLength + "-" + lastModified + "\"";
        }
        if ((ifNoneMatch = req.getHeader(IF_NONE_MATCH)) != null && etag != null && ifNoneMatch.indexOf(etag) != -1) {
            resp.setStatus(304);
            return true;
        }
        long ifModifiedSince = req.getDateHeader(IF_MODIFIED_SINCE);
        if (ifModifiedSince > -1L && lastModified > 0L && lastModified <= ifModifiedSince + 999L) {
            resp.setStatus(304);
            return true;
        }
        if (contentLength != -1) {
            resp.setContentLength(contentLength);
        }
        if ((contentType = servletContext.getMimeType(resourcePath)) == null) {
            contentType = servletContext.getMimeType(resourcePath);
        }
        if (contentType != null) {
            resp.setContentType(contentType);
        }
        if (lastModified > 0L) {
            resp.setDateHeader(LAST_MODIFIED, lastModified);
        }
        if (etag != null) {
            resp.setHeader(ETAG, etag);
        }
        InputStream is = null;
        try {
            is = connection.getInputStream();
            ServletOutputStream os = resp.getOutputStream();
            byte[] buffer = new byte[8192];
            int bytesRead = is.read(buffer);
            int writtenContentLength = 0;
            while (bytesRead != -1) {
                os.write(buffer, 0, bytesRead);
                writtenContentLength += bytesRead;
                bytesRead = is.read(buffer);
            }
            if (contentLength == -1 || contentLength != writtenContentLength) {
                resp.setContentLength(writtenContentLength);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return true;
    }
}

