/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.context;

import org.apache.airavata.common.context.RequestContext;

public class WorkflowContext {
    private static final ThreadLocal userThreadLocal = new InheritableThreadLocal();

    public static void set(RequestContext context) {
        userThreadLocal.set(context);
    }

    public static void unset() {
        userThreadLocal.remove();
    }

    public static RequestContext get() {
        return (RequestContext)userThreadLocal.get();
    }

    public static synchronized String getRequestUser() {
        RequestContext requestContext = (RequestContext)userThreadLocal.get();
        if (requestContext != null) {
            return requestContext.getUserIdentity();
        }
        return null;
    }

    public static synchronized String getGatewayId() {
        RequestContext requestContext = (RequestContext)userThreadLocal.get();
        if (requestContext != null) {
            return requestContext.getGatewayId();
        }
        return null;
    }
}

