/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client.authn;

import eu.unicore.samly2.assertion.AssertionParser;
import eu.unicore.samly2.assertion.AttributeAssertionParser;
import eu.unicore.security.wsutil.client.authn.AssertionsCache;
import eu.unicore.security.wsutil.samlclient.AuthnResponseAssertions;
import eu.unicore.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class InMemoryAssertionCache
implements AssertionsCache {
    protected static final Logger logger = Log.getLogger("unicore.security", AssertionsCache.class);
    protected final Map<String, AuthnResponseAssertions> store = new ConcurrentHashMap<String, AuthnResponseAssertions>();

    @Override
    public AuthnResponseAssertions get(String key) {
        return this.store.get(key);
    }

    @Override
    public void store(String key, AuthnResponseAssertions value) {
        if (logger.isDebugEnabled()) {
            try {
                StringBuilder sb = new StringBuilder();
                String nl = System.getProperty("line.separator");
                sb.append("Key: ").append(key).append(nl);
                for (AssertionParser assertionParser : value.getAuthNAssertions()) {
                    sb.append("Authn: ").append(assertionParser.getXMLBeanDoc()).append(nl);
                }
                for (AttributeAssertionParser attributeAssertionParser : value.getAttributeAssertions()) {
                    sb.append("Attrib: ").append(attributeAssertionParser.getXMLBeanDoc()).append(nl);
                }
                for (AssertionDocument assertionDocument : value.getOtherAssertions()) {
                    sb.append("Other: ").append(assertionDocument).append(nl);
                }
                logger.debug(sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.store.put(key, value);
    }
}

