/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.IGridFileFilter;
import java.util.regex.Pattern;
import org.unigrids.services.atomic.types.GridFileType;

public class GridFileFilter
implements IGridFileFilter {
    public static final int FILES_AND_FOLDERS = 0;
    public static final int ONLY_FILES = 1;
    public static final int ONLY_FOLDERS = 2;
    private int fileFolder = 0;
    private String initialCriteria;
    private String searchCriteria;
    private Pattern compiledPattern;
    private boolean doubleStarExists = false;
    private String criteriaBeforeDoubleStar;
    private Pattern compiledPrePattern;

    public GridFileFilter(String criteria) {
        this.setCriteria(criteria);
    }

    private static String syntaxCheck(String criteria) {
        if (!criteria.startsWith("/")) {
            criteria = "/" + criteria;
        }
        if (criteria.length() > 1 && criteria.endsWith("/")) {
            criteria = criteria.substring(0, criteria.length() - 1);
        }
        return criteria;
    }

    public static String translateCriteria(String criteria) {
        int i;
        if ((criteria = GridFileFilter.syntaxCheck(criteria)).indexOf("?") == -1 && criteria.indexOf("*") == -1) {
            return criteria;
        }
        int loopstop = criteria.length();
        for (i = 0; i < loopstop; ++i) {
            if (criteria.charAt(i) != '.') continue;
            String tempCrit = i != loopstop - 1 ? criteria.substring(0, i) + "[.]" + criteria.substring(i + 1, criteria.length()) : criteria.substring(0, i) + "[.]";
            criteria = tempCrit;
            i += 2;
            loopstop += 2;
        }
        criteria = criteria.replace('?', '.');
        loopstop = criteria.length();
        for (i = 0; i < loopstop; ++i) {
            String tmpString;
            if (criteria.charAt(i) != '*') continue;
            if (i + 1 < criteria.length() && criteria.charAt(i + 1) == '*') {
                criteria = tmpString = criteria.substring(0, i - 1) + "(/|(/.*/))" + criteria.substring(i + 3, criteria.length());
                loopstop += 6;
                i += 8;
                continue;
            }
            criteria = tmpString = criteria.substring(0, i) + "[^/]*" + criteria.substring(i + 1, criteria.length());
            loopstop += 4;
            i += 4;
        }
        return criteria;
    }

    @Override
    public void setCriteria(String criteria) {
        this.initialCriteria = criteria = GridFileFilter.syntaxCheck(criteria);
        this.searchCriteria = criteria = GridFileFilter.translateCriteria(criteria);
        this.compiledPattern = Pattern.compile(this.searchCriteria);
        int doubleStarPosition = criteria.indexOf("(/|(/.*/))");
        if (doubleStarPosition != -1) {
            this.doubleStarExists = true;
            this.criteriaBeforeDoubleStar = criteria.substring(0, doubleStarPosition);
            if (this.criteriaBeforeDoubleStar == "") {
                this.criteriaBeforeDoubleStar = "/";
            }
            this.compiledPrePattern = Pattern.compile(this.criteriaBeforeDoubleStar);
        }
    }

    public boolean setFileFolderCriteria(int i) {
        if (i < 0 || i > 2) {
            return false;
        }
        this.fileFolder = i;
        return true;
    }

    @Override
    public boolean match(GridFileType file) {
        switch (this.fileFolder) {
            case 1: {
                if (!file.getIsDirectory()) break;
                return false;
            }
            case 2: {
                if (file.getIsDirectory()) break;
                return false;
            }
        }
        String path = file.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.compiledPattern.matcher(path).matches();
    }

    @Override
    public boolean browseSubfolder(GridFileType file) {
        String cuttedCriteria;
        String criteria;
        String path = file.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        int depthPath = this.depthOfPath(path);
        if (this.doubleStarExists) {
            criteria = this.criteriaBeforeDoubleStar;
            cuttedCriteria = this.criteriaBeforeDoubleStar;
        } else {
            criteria = this.searchCriteria;
            cuttedCriteria = this.searchCriteria;
        }
        int depthCriteria = this.depthOfPath(criteria);
        if (depthPath == depthCriteria) {
            if (this.doubleStarExists) {
                return this.compiledPrePattern.matcher(path).matches();
            }
            return false;
        }
        if (depthPath < depthCriteria) {
            int counter = this.depthOfPath(path);
            int critCounter = 0;
            for (int i = 0; i < cuttedCriteria.length(); ++i) {
                if (cuttedCriteria.charAt(i) != '/') continue;
                if (i > 0) {
                    if (cuttedCriteria.charAt(i - 1) == '^' || ++critCounter != counter + 1) continue;
                    cuttedCriteria = cuttedCriteria.substring(0, i);
                    break;
                }
                if (++critCounter != counter + 1) continue;
                cuttedCriteria = cuttedCriteria.substring(0, i);
                break;
            }
            Pattern p = Pattern.compile(cuttedCriteria);
            return p.matcher(path).matches();
        }
        return this.doubleStarExists;
    }

    private int depthOfPath(String expression) {
        char searchChar = '/';
        int retval = 0;
        if (expression == null) {
            return -1;
        }
        for (int i = 0; i < expression.length(); ++i) {
            if (expression.charAt(i) != searchChar) continue;
            if (i > 0) {
                if (expression.charAt(i - 1) == '^') continue;
                ++retval;
                continue;
            }
            ++retval;
        }
        return retval;
    }

    @Override
    public String getInitCriteria() {
        return this.initialCriteria;
    }
}

