/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.merge.policy;

import org.apache.lucene.index.MergePolicy;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.lucene.engine.merge.policy.LogByteSizeMergePolicyProvider;
import org.compass.core.lucene.engine.merge.policy.LogDocMergePolicyProvider;
import org.compass.core.lucene.engine.merge.policy.MergePolicyProvider;
import org.compass.core.util.ClassUtils;

public class MergePolicyFactory {
    public static MergePolicy createMergePolicy(CompassSettings settings) throws ConfigurationException {
        MergePolicyProvider provider;
        String type = settings.getSetting("compass.engine.merge.policy.type", "logbytesize");
        if (type.equals("logbytesize")) {
            provider = new LogByteSizeMergePolicyProvider();
        } else if (type.equals("logdoc")) {
            provider = new LogDocMergePolicyProvider();
        } else {
            try {
                provider = (MergePolicyProvider)ClassUtils.forName(type, settings.getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to load/create merge policy provider [" + type + "]", e);
            }
        }
        return provider.create(settings);
    }
}

