/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.GroovyMap;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.Script;
import org.apache.airavata.gfac.core.cluster.JobSubmissionOutput;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.task.JobSubmissionTask;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJobSubmissionTask
implements JobSubmissionTask {
    private static final Logger log = LoggerFactory.getLogger(ForkJobSubmissionTask.class);

    public void init(Map<String, String> propertyMap) throws TaskException {
    }

    public TaskStatus execute(TaskContext taskContext) {
        TaskStatus taskStatus = new TaskStatus(TaskState.CREATED);
        try {
            ProcessContext processContext = taskContext.getParentProcessContext();
            JobModel jobModel = processContext.getJobModel();
            jobModel.setTaskId(taskContext.getTaskId());
            RemoteCluster remoteCluster = processContext.getJobSubmissionRemoteCluster();
            GroovyMap groovyMap = GFacUtils.createGroovyMap((ProcessContext)processContext, (TaskContext)taskContext);
            jobModel.setJobName(groovyMap.get(Script.JOB_NAME).toString());
            ResourceJobManager resourceJobManager = GFacUtils.getResourceJobManager((ProcessContext)processContext);
            JobManagerConfiguration jConfig = null;
            if (resourceJobManager != null) {
                jConfig = Factory.getJobManagerConfiguration(resourceJobManager);
            }
            JobStatus jobStatus = new JobStatus();
            File jobFile = GFacUtils.createJobFile((GroovyMap)groovyMap, (TaskContext)taskContext, (JobManagerConfiguration)jConfig);
            if (jobFile != null && jobFile.exists()) {
                jobModel.setJobDescription(FileUtils.readFileToString((File)jobFile));
                JobSubmissionOutput jobSubmissionOutput = remoteCluster.submitBatchJob(jobFile.getPath(), processContext.getWorkingDir());
                jobModel.setExitCode(jobSubmissionOutput.getExitCode());
                jobModel.setStdErr(jobSubmissionOutput.getStdErr());
                jobModel.setStdOut(jobSubmissionOutput.getStdOut());
                String jobId = jobSubmissionOutput.getJobId();
                if (jobId != null && !jobId.isEmpty()) {
                    jobModel.setJobId(jobId);
                    GFacUtils.saveJobModel((ProcessContext)processContext, (JobModel)jobModel);
                    jobStatus.setJobState(JobState.SUBMITTED);
                    jobStatus.setReason("Successfully Submitted to " + taskContext.getParentProcessContext().getComputeResourceDescription().getHostName());
                    jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                    jobModel.setJobStatuses(Arrays.asList(jobStatus));
                    GFacUtils.saveJobStatus((ProcessContext)taskContext.getParentProcessContext(), (JobModel)jobModel);
                    taskStatus = new TaskStatus(TaskState.COMPLETED);
                    taskStatus.setReason("Submitted job to compute resource");
                }
                if (jobId == null || jobId.isEmpty()) {
                    String msg = "expId:" + processContext.getProcessModel().getExperimentId() + " Couldn't find remote jobId for JobName:" + jobModel.getJobName() + ", both submit and verify steps doesn't return a valid JobId. Hence changing experiment state to Failed";
                    log.error(msg);
                    ErrorModel errorModel = new ErrorModel();
                    errorModel.setActualErrorMessage(msg);
                    errorModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
                    GFacUtils.saveExperimentError((ProcessContext)processContext, (ErrorModel)errorModel);
                    GFacUtils.saveProcessError((ProcessContext)processContext, (ErrorModel)errorModel);
                    GFacUtils.saveTaskError((TaskContext)taskContext, (ErrorModel)errorModel);
                    taskStatus.setState(TaskState.FAILED);
                    taskStatus.setReason("Couldn't find job id in both submitted and verified steps");
                } else {
                    GFacUtils.saveJobModel((ProcessContext)processContext, (JobModel)jobModel);
                }
            } else {
                taskStatus.setState(TaskState.FAILED);
                if (jobFile == null) {
                    taskStatus.setReason("JobFile is null");
                } else {
                    taskStatus.setReason("Job file doesn't exist");
                }
            }
        }
        catch (ApplicationSettingsException e) {
            String msg = "Error occurred while creating job descriptor";
            log.error(msg, (Throwable)e);
            taskStatus.setState(TaskState.FAILED);
            taskStatus.setReason(msg);
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
        }
        catch (AppCatalogException e) {
            String msg = "Error while instantiating app catalog";
            log.error(msg, (Throwable)e);
            taskStatus.setState(TaskState.FAILED);
            taskStatus.setReason(msg);
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
        }
        catch (GFacException e) {
            String msg = "Error occurred while submitting the job";
            log.error(msg, (Throwable)e);
            taskStatus.setState(TaskState.FAILED);
            taskStatus.setReason(msg);
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
        }
        catch (IOException e) {
            String msg = "Error while reading the content of the job file";
            log.error(msg, (Throwable)e);
            taskStatus.setState(TaskState.FAILED);
            taskStatus.setReason(msg);
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
        }
        return taskStatus;
    }

    public TaskStatus recover(TaskContext taskContext) {
        return this.execute(taskContext);
    }

    public TaskTypes getType() {
        return TaskTypes.JOB_SUBMISSION;
    }

    public JobStatus cancel(TaskContext taskcontext) {
        return null;
    }
}

