/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

public interface GSIConstants {
    public static final char DELEGATION_CHAR = 'D';
    public static final String[] GLOBUS_CIPHER = new String[]{"SSL_RSA_WITH_NULL_MD5"};
    public static final int DELEGATION_NONE = 1;
    public static final int DELEGATION_LIMITED = 2;
    public static final int DELEGATION_FULL = 3;
    public static final Integer MODE_GSI = new Integer(1);
    public static final Integer MODE_SSL = new Integer(2);
    public static final Integer DELEGATION_TYPE_FULL = new Integer(3);
    public static final Integer DELEGATION_TYPE_LIMITED = new Integer(2);
    public static final int EEC = 3;
    public static final int CA = 4;
    public static final int GSI_2_PROXY = 10;
    public static final int GSI_2_LIMITED_PROXY = 11;
    public static final int GSI_3_RESTRICTED_PROXY = 12;
    public static final int GSI_3_INDEPENDENT_PROXY = 13;
    public static final int GSI_3_IMPERSONATION_PROXY = 14;
    public static final int GSI_3_LIMITED_PROXY = 15;
    public static final int GSI_4_RESTRICTED_PROXY = 16;
    public static final int GSI_4_INDEPENDENT_PROXY = 17;
    public static final int GSI_4_IMPERSONATION_PROXY = 18;
    public static final int GSI_4_LIMITED_PROXY = 19;
    public static final String GSI_TRANSPORT = "org.globus.security.transport.type";
    public static final Integer SIGNATURE = new Integer(1);
    public static final Integer ENCRYPTION = new Integer(2);
    public static final Integer NONE = new Integer(Integer.MAX_VALUE);
    public static final String TRUSTED_CERTIFICATES = "org.globus.security.trustedCertifictes";
    public static final String AUTHZ_REQUIRED_WITH_DELEGATION = "org.globus.security.authz.required.delegation";

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DelegationType {
        NONE(1),
        LIMITED(2),
        FULL(3);

        private int code;

        private DelegationType(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }

        public static DelegationType get(int code) {
            for (DelegationType tmp : DelegationType.values()) {
                if (tmp.getCode() != code) continue;
                return tmp;
            }
            throw new IllegalArgumentException("invalid delegation type code");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificateType {
        EEC(3),
        CA(4),
        GSI_2_PROXY(10),
        GSI_2_LIMITED_PROXY(11),
        GSI_3_RESTRICTED_PROXY(12),
        GSI_3_INDEPENDENT_PROXY(13),
        GSI_3_IMPERSONATION_PROXY(14),
        GSI_3_LIMITED_PROXY(15),
        GSI_4_RESTRICTED_PROXY(16),
        GSI_4_INDEPENDENT_PROXY(17),
        GSI_4_IMPERSONATION_PROXY(18),
        GSI_4_LIMITED_PROXY(19),
        UNDEFINED(-1);

        private int code;

        private CertificateType(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }

        public static CertificateType get(int code) {
            for (CertificateType tmp : CertificateType.values()) {
                if (tmp.getCode() != code) continue;
                return tmp;
            }
            throw new IllegalArgumentException("invalid certificate type code");
        }
    }
}

