/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.util;

import java.util.List;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;

public class AppInterfaceUtil {
    public static ApplicationInterfaceDescription createAppInterface(String applicationName, List<String> appModules, List<InputDataObjectType> appInputs, List<OutputDataObjectType> appOutputs) {
        ApplicationInterfaceDescription interfaceDescription = new ApplicationInterfaceDescription();
        interfaceDescription.setApplicationName(applicationName);
        interfaceDescription.setApplicationModules(appModules);
        interfaceDescription.setApplicationInputs(appInputs);
        interfaceDescription.setApplicationOutputs(appOutputs);
        return interfaceDescription;
    }

    public static InputDataObjectType createApplicationInput(String name, String value, DataType type, String applicationArgument, int order, boolean standardInput, String userFriendlyDesc, String metadata) {
        InputDataObjectType appInput = new InputDataObjectType();
        appInput.setName(name);
        appInput.setValue(value);
        appInput.setType(type);
        appInput.setMetaData(metadata);
        appInput.setApplicationArgument(applicationArgument);
        appInput.setInputOrder(order);
        appInput.setUserFriendlyDescription(userFriendlyDesc);
        appInput.setStandardInput(standardInput);
        return appInput;
    }

    public static OutputDataObjectType createApplicationOutput(String name, String value, DataType type) {
        OutputDataObjectType appOutput = new OutputDataObjectType();
        appOutput.setName(name);
        appOutput.setValue(value);
        appOutput.setType(type);
        return appOutput;
    }
}

