/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)", date = "2016-10-21")
public class ResourceAggregate implements org.apache.thrift.TBase<ResourceAggregate, ResourceAggregate._Fields>, java.io.Serializable, Cloneable, Comparable<ResourceAggregate> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("ResourceAggregate");

  private static final org.apache.thrift.protocol.TField NUM_CPUS_FIELD_DESC = new org.apache.thrift.protocol.TField("numCpus", org.apache.thrift.protocol.TType.DOUBLE, (short)1);
  private static final org.apache.thrift.protocol.TField RAM_MB_FIELD_DESC = new org.apache.thrift.protocol.TField("ramMb", org.apache.thrift.protocol.TType.I64, (short)2);
  private static final org.apache.thrift.protocol.TField DISK_MB_FIELD_DESC = new org.apache.thrift.protocol.TField("diskMb", org.apache.thrift.protocol.TType.I64, (short)3);
  private static final org.apache.thrift.protocol.TField RESOURCES_FIELD_DESC = new org.apache.thrift.protocol.TField("resources", org.apache.thrift.protocol.TType.SET, (short)4);

  private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
  static {
    schemes.put(StandardScheme.class, new ResourceAggregateStandardSchemeFactory());
    schemes.put(TupleScheme.class, new ResourceAggregateTupleSchemeFactory());
  }

  /**
   * Number of CPU cores allotted.
   */
  public double numCpus; // required
  /**
   * Megabytes of RAM allotted.
   */
  public long ramMb; // required
  /**
   * Megabytes of disk space allotted.
   */
  public long diskMb; // required
  /**
   * Aggregated resource values.
   */
  public Set<Resource> resources; // required

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    /**
     * Number of CPU cores allotted.
     */
    NUM_CPUS((short)1, "numCpus"),
    /**
     * Megabytes of RAM allotted.
     */
    RAM_MB((short)2, "ramMb"),
    /**
     * Megabytes of disk space allotted.
     */
    DISK_MB((short)3, "diskMb"),
    /**
     * Aggregated resource values.
     */
    RESOURCES((short)4, "resources");

    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 1: // NUM_CPUS
          return NUM_CPUS;
        case 2: // RAM_MB
          return RAM_MB;
        case 3: // DISK_MB
          return DISK_MB;
        case 4: // RESOURCES
          return RESOURCES;
        default:
          return null;
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __NUMCPUS_ISSET_ID = 0;
  private static final int __RAMMB_ISSET_ID = 1;
  private static final int __DISKMB_ISSET_ID = 2;
  private byte __isset_bitfield = 0;
  public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
  static {
    Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.NUM_CPUS, new org.apache.thrift.meta_data.FieldMetaData("numCpus", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.DOUBLE)));
    tmpMap.put(_Fields.RAM_MB, new org.apache.thrift.meta_data.FieldMetaData("ramMb", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.DISK_MB, new org.apache.thrift.meta_data.FieldMetaData("diskMb", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.RESOURCES, new org.apache.thrift.meta_data.FieldMetaData("resources", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Resource.class))));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(ResourceAggregate.class, metaDataMap);
  }

  public ResourceAggregate() {
  }

  public ResourceAggregate(
    double numCpus,
    long ramMb,
    long diskMb,
    Set<Resource> resources)
  {
    this();
    this.numCpus = numCpus;
    setNumCpusIsSet(true);
    this.ramMb = ramMb;
    setRamMbIsSet(true);
    this.diskMb = diskMb;
    setDiskMbIsSet(true);
    this.resources = resources;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public ResourceAggregate(ResourceAggregate other) {
    __isset_bitfield = other.__isset_bitfield;
    this.numCpus = other.numCpus;
    this.ramMb = other.ramMb;
    this.diskMb = other.diskMb;
    if (other.isSetResources()) {
      Set<Resource> __this__resources = new HashSet<Resource>(other.resources.size());
      for (Resource other_element : other.resources) {
        __this__resources.add(new Resource(other_element));
      }
      this.resources = __this__resources;
    }
  }

  public ResourceAggregate deepCopy() {
    return new ResourceAggregate(this);
  }

  @Override
  public void clear() {
    setNumCpusIsSet(false);
    this.numCpus = 0.0;
    setRamMbIsSet(false);
    this.ramMb = 0;
    setDiskMbIsSet(false);
    this.diskMb = 0;
    this.resources = null;
  }

  /**
   * Number of CPU cores allotted.
   */
  public double getNumCpus() {
    return this.numCpus;
  }

  /**
   * Number of CPU cores allotted.
   */
  public ResourceAggregate setNumCpus(double numCpus) {
    this.numCpus = numCpus;
    setNumCpusIsSet(true);
    return this;
  }

  public void unsetNumCpus() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __NUMCPUS_ISSET_ID);
  }

  /** Returns true if field numCpus is set (has been assigned a value) and false otherwise */
  public boolean isSetNumCpus() {
    return EncodingUtils.testBit(__isset_bitfield, __NUMCPUS_ISSET_ID);
  }

  public void setNumCpusIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __NUMCPUS_ISSET_ID, value);
  }

  /**
   * Megabytes of RAM allotted.
   */
  public long getRamMb() {
    return this.ramMb;
  }

  /**
   * Megabytes of RAM allotted.
   */
  public ResourceAggregate setRamMb(long ramMb) {
    this.ramMb = ramMb;
    setRamMbIsSet(true);
    return this;
  }

  public void unsetRamMb() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __RAMMB_ISSET_ID);
  }

  /** Returns true if field ramMb is set (has been assigned a value) and false otherwise */
  public boolean isSetRamMb() {
    return EncodingUtils.testBit(__isset_bitfield, __RAMMB_ISSET_ID);
  }

  public void setRamMbIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __RAMMB_ISSET_ID, value);
  }

  /**
   * Megabytes of disk space allotted.
   */
  public long getDiskMb() {
    return this.diskMb;
  }

  /**
   * Megabytes of disk space allotted.
   */
  public ResourceAggregate setDiskMb(long diskMb) {
    this.diskMb = diskMb;
    setDiskMbIsSet(true);
    return this;
  }

  public void unsetDiskMb() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __DISKMB_ISSET_ID);
  }

  /** Returns true if field diskMb is set (has been assigned a value) and false otherwise */
  public boolean isSetDiskMb() {
    return EncodingUtils.testBit(__isset_bitfield, __DISKMB_ISSET_ID);
  }

  public void setDiskMbIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __DISKMB_ISSET_ID, value);
  }

  public int getResourcesSize() {
    return (this.resources == null) ? 0 : this.resources.size();
  }

  public java.util.Iterator<Resource> getResourcesIterator() {
    return (this.resources == null) ? null : this.resources.iterator();
  }

  public void addToResources(Resource elem) {
    if (this.resources == null) {
      this.resources = new HashSet<Resource>();
    }
    this.resources.add(elem);
  }

  /**
   * Aggregated resource values.
   */
  public Set<Resource> getResources() {
    return this.resources;
  }

  /**
   * Aggregated resource values.
   */
  public ResourceAggregate setResources(Set<Resource> resources) {
    this.resources = resources;
    return this;
  }

  public void unsetResources() {
    this.resources = null;
  }

  /** Returns true if field resources is set (has been assigned a value) and false otherwise */
  public boolean isSetResources() {
    return this.resources != null;
  }

  public void setResourcesIsSet(boolean value) {
    if (!value) {
      this.resources = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case NUM_CPUS:
      if (value == null) {
        unsetNumCpus();
      } else {
        setNumCpus((Double)value);
      }
      break;

    case RAM_MB:
      if (value == null) {
        unsetRamMb();
      } else {
        setRamMb((Long)value);
      }
      break;

    case DISK_MB:
      if (value == null) {
        unsetDiskMb();
      } else {
        setDiskMb((Long)value);
      }
      break;

    case RESOURCES:
      if (value == null) {
        unsetResources();
      } else {
        setResources((Set<Resource>)value);
      }
      break;

    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case NUM_CPUS:
      return getNumCpus();

    case RAM_MB:
      return getRamMb();

    case DISK_MB:
      return getDiskMb();

    case RESOURCES:
      return getResources();

    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case NUM_CPUS:
      return isSetNumCpus();
    case RAM_MB:
      return isSetRamMb();
    case DISK_MB:
      return isSetDiskMb();
    case RESOURCES:
      return isSetResources();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof ResourceAggregate)
      return this.equals((ResourceAggregate)that);
    return false;
  }

  public boolean equals(ResourceAggregate that) {
    if (that == null)
      return false;

    boolean this_present_numCpus = true;
    boolean that_present_numCpus = true;
    if (this_present_numCpus || that_present_numCpus) {
      if (!(this_present_numCpus && that_present_numCpus))
        return false;
      if (this.numCpus != that.numCpus)
        return false;
    }

    boolean this_present_ramMb = true;
    boolean that_present_ramMb = true;
    if (this_present_ramMb || that_present_ramMb) {
      if (!(this_present_ramMb && that_present_ramMb))
        return false;
      if (this.ramMb != that.ramMb)
        return false;
    }

    boolean this_present_diskMb = true;
    boolean that_present_diskMb = true;
    if (this_present_diskMb || that_present_diskMb) {
      if (!(this_present_diskMb && that_present_diskMb))
        return false;
      if (this.diskMb != that.diskMb)
        return false;
    }

    boolean this_present_resources = true && this.isSetResources();
    boolean that_present_resources = true && that.isSetResources();
    if (this_present_resources || that_present_resources) {
      if (!(this_present_resources && that_present_resources))
        return false;
      if (!this.resources.equals(that.resources))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    List<Object> list = new ArrayList<Object>();

    boolean present_numCpus = true;
    list.add(present_numCpus);
    if (present_numCpus)
      list.add(numCpus);

    boolean present_ramMb = true;
    list.add(present_ramMb);
    if (present_ramMb)
      list.add(ramMb);

    boolean present_diskMb = true;
    list.add(present_diskMb);
    if (present_diskMb)
      list.add(diskMb);

    boolean present_resources = true && (isSetResources());
    list.add(present_resources);
    if (present_resources)
      list.add(resources);

    return list.hashCode();
  }

  @Override
  public int compareTo(ResourceAggregate other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = Boolean.valueOf(isSetNumCpus()).compareTo(other.isSetNumCpus());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetNumCpus()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.numCpus, other.numCpus);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetRamMb()).compareTo(other.isSetRamMb());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetRamMb()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ramMb, other.ramMb);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetDiskMb()).compareTo(other.isSetDiskMb());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetDiskMb()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.diskMb, other.diskMb);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetResources()).compareTo(other.isSetResources());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetResources()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.resources, other.resources);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
    schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("ResourceAggregate(");
    boolean first = true;

    sb.append("numCpus:");
    sb.append(this.numCpus);
    first = false;
    if (!first) sb.append(", ");
    sb.append("ramMb:");
    sb.append(this.ramMb);
    first = false;
    if (!first) sb.append(", ");
    sb.append("diskMb:");
    sb.append(this.diskMb);
    first = false;
    if (!first) sb.append(", ");
    sb.append("resources:");
    if (this.resources == null) {
      sb.append("null");
    } else {
      sb.append(this.resources);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    // check for sub-struct validity
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
      __isset_bitfield = 0;
      read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class ResourceAggregateStandardSchemeFactory implements SchemeFactory {
    public ResourceAggregateStandardScheme getScheme() {
      return new ResourceAggregateStandardScheme();
    }
  }

  private static class ResourceAggregateStandardScheme extends StandardScheme<ResourceAggregate> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, ResourceAggregate struct) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true)
      {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (schemeField.id) {
          case 1: // NUM_CPUS
            if (schemeField.type == org.apache.thrift.protocol.TType.DOUBLE) {
              struct.numCpus = iprot.readDouble();
              struct.setNumCpusIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 2: // RAM_MB
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.ramMb = iprot.readI64();
              struct.setRamMbIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 3: // DISK_MB
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.diskMb = iprot.readI64();
              struct.setDiskMbIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 4: // RESOURCES
            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
              {
                org.apache.thrift.protocol.TSet _set84 = iprot.readSetBegin();
                struct.resources = new HashSet<Resource>(2*_set84.size);
                Resource _elem85;
                for (int _i86 = 0; _i86 < _set84.size; ++_i86)
                {
                  _elem85 = new Resource();
                  _elem85.read(iprot);
                  struct.resources.add(_elem85);
                }
                iprot.readSetEnd();
              }
              struct.setResourcesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, ResourceAggregate struct) throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldBegin(NUM_CPUS_FIELD_DESC);
      oprot.writeDouble(struct.numCpus);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(RAM_MB_FIELD_DESC);
      oprot.writeI64(struct.ramMb);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(DISK_MB_FIELD_DESC);
      oprot.writeI64(struct.diskMb);
      oprot.writeFieldEnd();
      if (struct.resources != null) {
        oprot.writeFieldBegin(RESOURCES_FIELD_DESC);
        {
          oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, struct.resources.size()));
          for (Resource _iter87 : struct.resources)
          {
            _iter87.write(oprot);
          }
          oprot.writeSetEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

  }

  private static class ResourceAggregateTupleSchemeFactory implements SchemeFactory {
    public ResourceAggregateTupleScheme getScheme() {
      return new ResourceAggregateTupleScheme();
    }
  }

  private static class ResourceAggregateTupleScheme extends TupleScheme<ResourceAggregate> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, ResourceAggregate struct) throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol) prot;
      BitSet optionals = new BitSet();
      if (struct.isSetNumCpus()) {
        optionals.set(0);
      }
      if (struct.isSetRamMb()) {
        optionals.set(1);
      }
      if (struct.isSetDiskMb()) {
        optionals.set(2);
      }
      if (struct.isSetResources()) {
        optionals.set(3);
      }
      oprot.writeBitSet(optionals, 4);
      if (struct.isSetNumCpus()) {
        oprot.writeDouble(struct.numCpus);
      }
      if (struct.isSetRamMb()) {
        oprot.writeI64(struct.ramMb);
      }
      if (struct.isSetDiskMb()) {
        oprot.writeI64(struct.diskMb);
      }
      if (struct.isSetResources()) {
        {
          oprot.writeI32(struct.resources.size());
          for (Resource _iter88 : struct.resources)
          {
            _iter88.write(oprot);
          }
        }
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, ResourceAggregate struct) throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol) prot;
      BitSet incoming = iprot.readBitSet(4);
      if (incoming.get(0)) {
        struct.numCpus = iprot.readDouble();
        struct.setNumCpusIsSet(true);
      }
      if (incoming.get(1)) {
        struct.ramMb = iprot.readI64();
        struct.setRamMbIsSet(true);
      }
      if (incoming.get(2)) {
        struct.diskMb = iprot.readI64();
        struct.setDiskMbIsSet(true);
      }
      if (incoming.get(3)) {
        {
          org.apache.thrift.protocol.TSet _set89 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.resources = new HashSet<Resource>(2*_set89.size);
          Resource _elem90;
          for (int _i91 = 0; _i91 < _set89.size; ++_i91)
          {
            _elem90 = new Resource();
            _elem90.read(iprot);
            struct.resources.add(_elem90);
          }
        }
        struct.setResourcesIsSet(true);
      }
    }
  }

}

