/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import org.apache.activemq.artemis.core.paging.cursor.PagePosition;

public class PagePositionImpl
implements PagePosition {
    private long pageNr;
    private int messageNr;
    private int fileOffset = -1;
    private long recordID = -1L;
    private long persistentSize;

    public PagePositionImpl(long pageNr, int messageNr, int fileOffset) {
        this();
        this.pageNr = pageNr;
        this.messageNr = messageNr;
        this.fileOffset = fileOffset;
    }

    public PagePositionImpl(long pageNr, int messageNr) {
        this(pageNr, messageNr, -1);
    }

    public PagePositionImpl() {
    }

    @Override
    public long getRecordID() {
        return this.recordID;
    }

    @Override
    public void setRecordID(long recordID) {
        this.recordID = recordID;
    }

    @Override
    public long getPageNr() {
        return this.pageNr;
    }

    @Override
    public int getMessageNr() {
        return this.messageNr;
    }

    @Override
    public int getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public long getPersistentSize() {
        return this.persistentSize;
    }

    @Override
    public void setPersistentSize(long persistentSize) {
        this.persistentSize = persistentSize;
    }

    @Override
    public int compareTo(PagePosition o) {
        if (this.pageNr > o.getPageNr()) {
            return 1;
        }
        if (this.pageNr < o.getPageNr()) {
            return -1;
        }
        return Long.compare(this.recordID, o.getRecordID());
    }

    @Override
    public PagePosition nextMessage() {
        return new PagePositionImpl(this.pageNr, this.messageNr + 1);
    }

    @Override
    public PagePosition nextPage() {
        return new PagePositionImpl(this.pageNr + 1L, 0, 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.messageNr;
        result = 31 * result + (int)(this.pageNr ^ this.pageNr >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PagePositionImpl other = (PagePositionImpl)obj;
        if (this.messageNr != other.messageNr) {
            return false;
        }
        return this.pageNr == other.pageNr;
    }

    public String toString() {
        return "PagePositionImpl [pageNr=" + this.pageNr + ", messageNr=" + this.messageNr + ", recordID=" + this.recordID + ", fileOffset=" + this.fileOffset + "]";
    }

    protected void finalize() {
    }
}

