/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.utils.ReusableLatch;

public class TransactionCallback
implements IOCallback {
    private final ReusableLatch countLatch = new ReusableLatch();
    private volatile String errorMessage = null;
    private volatile int errorCode = 0;
    private final AtomicInteger up = new AtomicInteger();
    private int done = 0;
    private volatile IOCallback delegateCompletion;

    public void countUp() {
        this.up.incrementAndGet();
        this.countLatch.countUp();
    }

    @Override
    public void done() {
        this.countLatch.countDown();
        if (++this.done == this.up.get() && this.delegateCompletion != null) {
            IOCallback delegateToCall = this.delegateCompletion;
            this.delegateCompletion = null;
            delegateToCall.done();
        }
    }

    public void waitCompletion() throws InterruptedException {
        this.countLatch.await();
        if (this.errorMessage != null) {
            throw new IllegalStateException("Error on Transaction: " + this.errorCode + " - " + this.errorMessage);
        }
    }

    @Override
    public void onError(int errorCode, String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.countLatch.countDown();
        if (this.delegateCompletion != null) {
            this.delegateCompletion.onError(errorCode, errorMessage);
        }
    }

    public IOCallback getDelegateCompletion() {
        return this.delegateCompletion;
    }

    public void setDelegateCompletion(IOCallback delegateCompletion) {
        this.delegateCompletion = delegateCompletion;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

