/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Objects;
import org.apache.camel.spi.Resource;

public abstract class ResourceSupport
implements Resource {
    private final String scheme;
    private final String location;

    protected ResourceSupport(String scheme, String location) {
        this.scheme = scheme;
        this.location = location;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        String prefix = this.scheme + ":";
        if (this.location.startsWith(prefix)) {
            return "Resource[" + this.location + "]";
        }
        return "Resource[" + prefix + this.location + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSupport that = (ResourceSupport)o;
        return this.scheme.equals(that.scheme) && this.location.equals(that.location);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.location);
    }
}

