/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;

final class KllDoublesHelper {
    KllDoublesHelper() {
    }

    static void mergeDoubleImpl(KllDoublesSketch mySketch, KllSketch other) {
        double[] otherDoubleItemsArr;
        KllDoublesSketch otherDblSk = (KllDoublesSketch)other;
        if (otherDblSk.isEmpty()) {
            return;
        }
        mySketch.nullSortedView();
        long finalN = mySketch.getN() + otherDblSk.getN();
        int otherNumLevels = otherDblSk.getNumLevels();
        int[] otherLevelsArr = otherDblSk.getLevelsArray();
        double myMin = mySketch.isEmpty() ? Double.NaN : mySketch.getMinDoubleItem();
        double myMax = mySketch.isEmpty() ? Double.NaN : mySketch.getMaxDoubleItem();
        int myMinK = mySketch.getMinK();
        if (otherDblSk.isCompactSingleItem()) {
            KllDoublesHelper.updateDouble(mySketch, otherDblSk.getDoubleSingleItem());
            otherDoubleItemsArr = new double[]{};
        } else {
            otherDoubleItemsArr = otherDblSk.getDoubleItemsArray();
            for (int i = otherLevelsArr[0]; i < otherLevelsArr[1]; ++i) {
                KllDoublesHelper.updateDouble(mySketch, otherDoubleItemsArr[i]);
            }
        }
        int myCurNumLevels = mySketch.getNumLevels();
        int[] myCurLevelsArr = mySketch.getLevelsArray();
        double[] myCurDoubleItemsArr = mySketch.getDoubleItemsArray();
        int myNewNumLevels = myCurNumLevels;
        int[] myNewLevelsArr = myCurLevelsArr;
        double[] myNewDoubleItemsArr = myCurDoubleItemsArr;
        if (otherNumLevels > 1 && !otherDblSk.isCompactSingleItem()) {
            int tmpSpaceNeeded = mySketch.getNumRetained() + KllHelper.getNumRetainedAboveLevelZero(otherNumLevels, otherLevelsArr);
            double[] workbuf = new double[tmpSpaceNeeded];
            int ub = KllHelper.ubOnNumLevels(finalN);
            int[] worklevels = new int[ub + 2];
            int[] outlevels = new int[ub + 2];
            int provisionalNumLevels = Math.max(myCurNumLevels, otherNumLevels);
            KllDoublesHelper.populateDoubleWorkArrays(workbuf, worklevels, provisionalNumLevels, myCurNumLevels, myCurLevelsArr, myCurDoubleItemsArr, otherNumLevels, otherLevelsArr, otherDoubleItemsArr);
            int[] result = KllDoublesHelper.generalDoublesCompress(mySketch.getK(), mySketch.getM(), provisionalNumLevels, workbuf, worklevels, workbuf, outlevels, mySketch.isLevelZeroSorted(), KllSketch.random);
            int targetItemCount = result[1];
            int curItemCount = result[2];
            myNewNumLevels = result[0];
            assert (myNewNumLevels <= ub);
            myNewDoubleItemsArr = targetItemCount == myCurDoubleItemsArr.length ? myCurDoubleItemsArr : new double[targetItemCount];
            int freeSpaceAtBottom = targetItemCount - curItemCount;
            System.arraycopy(workbuf, outlevels[0], myNewDoubleItemsArr, freeSpaceAtBottom, curItemCount);
            int theShift = freeSpaceAtBottom - outlevels[0];
            int finalLevelsArrLen = myCurLevelsArr.length < myNewNumLevels + 1 ? myNewNumLevels + 1 : myCurLevelsArr.length;
            myNewLevelsArr = new int[finalLevelsArrLen];
            for (int lvl = 0; lvl < myNewNumLevels + 1; ++lvl) {
                myNewLevelsArr[lvl] = outlevels[lvl] + theShift;
            }
            if (mySketch.serialVersionUpdatable) {
                mySketch.wmem = KllHelper.memorySpaceMgmt(mySketch, myNewLevelsArr.length, myNewDoubleItemsArr.length);
            }
        }
        mySketch.setN(finalN);
        if (otherDblSk.isEstimationMode()) {
            mySketch.setMinK(Math.min(myMinK, otherDblSk.getMinK()));
        }
        mySketch.setNumLevels(myNewNumLevels);
        mySketch.setLevelsArray(myNewLevelsArr);
        mySketch.setDoubleItemsArray(myNewDoubleItemsArr);
        double otherMin = otherDblSk.getMinDoubleItem();
        double otherMax = otherDblSk.getMaxDoubleItem();
        mySketch.setMinDoubleItem(KllDoublesHelper.resolveDoubleMinItem(myMin, otherMin));
        mySketch.setMaxDoubleItem(KllDoublesHelper.resolveDoubleMaxItem(myMax, otherMax));
        assert (KllHelper.sumTheSampleWeights(mySketch.getNumLevels(), mySketch.getLevelsArray()) == mySketch.getN());
    }

    static void mergeSortedDoubleArrays(double[] bufA, int startA, int lenA, double[] bufB, int startB, int lenB, double[] bufC, int startC) {
        int lenC = lenA + lenB;
        int limA = startA + lenA;
        int limB = startB + lenB;
        int limC = startC + lenC;
        int a = startA;
        int b = startB;
        for (int c = startC; c < limC; ++c) {
            if (a == limA) {
                bufC[c] = bufB[b];
                ++b;
                continue;
            }
            if (b == limB) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            if (bufA[a] < bufB[b]) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            bufC[c] = bufB[b];
            ++b;
        }
        assert (a == limA);
        assert (b == limB);
    }

    static void randomlyHalveDownDoubles(double[] buf, int start, int length, Random random) {
        assert (Util.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + offset;
        for (int i = start; i < start + half_length; ++i) {
            buf[i] = buf[j];
            j += 2;
        }
    }

    static void randomlyHalveUpDoubles(double[] buf, int start, int length, Random random) {
        assert (Util.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + length - 1 - offset;
        for (int i = start + length - 1; i >= start + half_length; --i) {
            buf[i] = buf[j];
            j -= 2;
        }
    }

    static void updateDouble(KllDoublesSketch dblSk, double item) {
        if (Double.isNaN(item)) {
            return;
        }
        double prevMin = dblSk.getMinDoubleItem();
        double prevMax = dblSk.getMaxDoubleItem();
        dblSk.setMinDoubleItem(KllDoublesHelper.resolveDoubleMinItem(prevMin, item));
        dblSk.setMaxDoubleItem(KllDoublesHelper.resolveDoubleMaxItem(prevMax, item));
        if (dblSk.getLevelsArray()[0] == 0) {
            KllHelper.compressWhileUpdatingSketch(dblSk);
        }
        int myLevelsArrAtZero = dblSk.getLevelsArray()[0];
        dblSk.incN();
        dblSk.setLevelZeroSorted(false);
        int nextPos = myLevelsArrAtZero - 1;
        assert (myLevelsArrAtZero >= 0);
        dblSk.setLevelsArrayAt(0, nextPos);
        dblSk.setDoubleItemsArrayAt(nextPos, item);
    }

    private static int[] generalDoublesCompress(int k, int m, int numLevelsIn, double[] inBuf, int[] inLevels, double[] outBuf, int[] outLevels, boolean isLevelZeroSorted, Random random) {
        assert (numLevelsIn > 0);
        int numLevels = numLevelsIn;
        int currentItemCount = inLevels[numLevels] - inLevels[0];
        int targetItemCount = KllHelper.computeTotalItemCapacity(k, m, numLevels);
        boolean doneYet = false;
        outLevels[0] = 0;
        int curLevel = -1;
        while (!doneYet) {
            if (++curLevel == numLevels - 1) {
                inLevels[curLevel + 2] = inLevels[curLevel + 1];
            }
            int rawBeg = inLevels[curLevel];
            int rawLim = inLevels[curLevel + 1];
            int rawPop = rawLim - rawBeg;
            if (currentItemCount < targetItemCount || rawPop < KllHelper.levelCapacity(k, numLevels, curLevel, m)) {
                assert (rawBeg >= outLevels[curLevel]);
                System.arraycopy(inBuf, rawBeg, outBuf, outLevels[curLevel], rawPop);
                outLevels[curLevel + 1] = outLevels[curLevel] + rawPop;
            } else {
                int popAbove = inLevels[curLevel + 2] - rawLim;
                boolean oddPop = Util.isOdd(rawPop);
                int adjBeg = oddPop ? 1 + rawBeg : rawBeg;
                int adjPop = oddPop ? rawPop - 1 : rawPop;
                int halfAdjPop = adjPop / 2;
                if (oddPop) {
                    outBuf[outLevels[curLevel]] = inBuf[rawBeg];
                    outLevels[curLevel + 1] = outLevels[curLevel] + 1;
                } else {
                    outLevels[curLevel + 1] = outLevels[curLevel];
                }
                if (curLevel == 0 && !isLevelZeroSorted) {
                    Arrays.sort(inBuf, adjBeg, adjBeg + adjPop);
                }
                if (popAbove == 0) {
                    KllDoublesHelper.randomlyHalveUpDoubles(inBuf, adjBeg, adjPop, random);
                } else {
                    KllDoublesHelper.randomlyHalveDownDoubles(inBuf, adjBeg, adjPop, random);
                    KllDoublesHelper.mergeSortedDoubleArrays(inBuf, adjBeg, halfAdjPop, inBuf, rawLim, popAbove, inBuf, adjBeg + halfAdjPop);
                }
                currentItemCount -= halfAdjPop;
                inLevels[curLevel + 1] = inLevels[curLevel + 1] - halfAdjPop;
                if (curLevel == numLevels - 1) {
                    targetItemCount += KllHelper.levelCapacity(k, ++numLevels, 0, m);
                }
            }
            if (curLevel != numLevels - 1) continue;
            doneYet = true;
        }
        assert (outLevels[numLevels] - outLevels[0] == currentItemCount);
        return new int[]{numLevels, targetItemCount, currentItemCount};
    }

    private static void populateDoubleWorkArrays(double[] workbuf, int[] worklevels, int provisionalNumLevels, int myCurNumLevels, int[] myCurLevelsArr, double[] myCurDoubleItemsArr, int otherNumLevels, int[] otherLevelsArr, double[] otherDoubleItemsArr) {
        worklevels[0] = 0;
        int selfPopZero = KllHelper.currentLevelSize(0, myCurNumLevels, myCurLevelsArr);
        System.arraycopy(myCurDoubleItemsArr, myCurLevelsArr[0], workbuf, worklevels[0], selfPopZero);
        worklevels[1] = worklevels[0] + selfPopZero;
        for (int lvl = 1; lvl < provisionalNumLevels; ++lvl) {
            int selfPop = KllHelper.currentLevelSize(lvl, myCurNumLevels, myCurLevelsArr);
            int otherPop = KllHelper.currentLevelSize(lvl, otherNumLevels, otherLevelsArr);
            worklevels[lvl + 1] = worklevels[lvl] + selfPop + otherPop;
            if (selfPop > 0 && otherPop == 0) {
                System.arraycopy(myCurDoubleItemsArr, myCurLevelsArr[lvl], workbuf, worklevels[lvl], selfPop);
                continue;
            }
            if (selfPop == 0 && otherPop > 0) {
                System.arraycopy(otherDoubleItemsArr, otherLevelsArr[lvl], workbuf, worklevels[lvl], otherPop);
                continue;
            }
            if (selfPop <= 0 || otherPop <= 0) continue;
            KllDoublesHelper.mergeSortedDoubleArrays(myCurDoubleItemsArr, myCurLevelsArr[lvl], selfPop, otherDoubleItemsArr, otherLevelsArr[lvl], otherPop, workbuf, worklevels[lvl]);
        }
    }

    private static double resolveDoubleMaxItem(double myMax, double otherMax) {
        if (Double.isNaN(myMax) && Double.isNaN(otherMax)) {
            return Double.NaN;
        }
        if (Double.isNaN(myMax)) {
            return otherMax;
        }
        if (Double.isNaN(otherMax)) {
            return myMax;
        }
        return Math.max(myMax, otherMax);
    }

    private static double resolveDoubleMinItem(double myMin, double otherMin) {
        if (Double.isNaN(myMin) && Double.isNaN(otherMin)) {
            return Double.NaN;
        }
        if (Double.isNaN(myMin)) {
            return otherMin;
        }
        if (Double.isNaN(otherMin)) {
            return myMin;
        }
        return Math.min(myMin, otherMin);
    }
}

