/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.miniclusterImpl;

import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.compactor.Compactor;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.ProcessNotFoundException;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.tserver.ScanServer;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniAccumuloClusterControl
implements ClusterControl {
    private static final Logger log = LoggerFactory.getLogger(MiniAccumuloClusterControl.class);
    protected MiniAccumuloClusterImpl cluster;
    Process zooKeeperProcess = null;
    Process managerProcess = null;
    Process gcProcess = null;
    Process monitor = null;
    Process coordinatorProcess = null;
    final List<Process> tabletServerProcesses = new ArrayList<Process>();
    final List<Process> scanServerProcesses = new ArrayList<Process>();
    final List<Process> compactorProcesses = new ArrayList<Process>();

    public MiniAccumuloClusterControl(MiniAccumuloClusterImpl cluster) {
        Objects.requireNonNull(cluster);
        this.cluster = cluster;
    }

    public void start(ServerType server) throws IOException {
        this.start(server, null);
    }

    @Override
    public int exec(Class<?> clz, String[] args) throws IOException {
        int exitCode;
        Process p = this.cluster.exec(clz, args).getProcess();
        try {
            exitCode = p.waitFor();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted waiting for process to exit", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        return exitCode;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    public Map.Entry<Integer, String> execWithStdout(Class<?> clz, String[] args) throws IOException {
        int exitCode;
        MiniAccumuloClusterImpl.ProcessInfo pi = this.cluster.exec(clz, args);
        try {
            exitCode = pi.getProcess().waitFor();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted waiting for process to exit", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        return Maps.immutableEntry((Object)exitCode, (Object)pi.readStdOut());
    }

    @Override
    public void adminStopAll() throws IOException {
        Process p = this.cluster.exec(Admin.class, "stopAll").getProcess();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        if (p.exitValue() != 0) {
            throw new IOException("Failed to run `accumulo admin stopAll`");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TExternalCompactionList getRunningCompactions(ClientContext context) throws TException {
        Optional coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)context);
        if (coordinatorHost.isEmpty()) {
            throw new TTransportException("Unable to get CompactionCoordinator address from ZooKeeper");
        }
        CompactionCoordinatorService.Client client = (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)((HostAndPort)coordinatorHost.orElseThrow()), (ClientContext)context);
        try {
            TExternalCompactionList tExternalCompactionList = client.getRunningCompactions(TraceUtil.traceInfo(), context.rpcCreds());
            return tExternalCompactionList;
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
        }
    }

    @Override
    public synchronized void startCoordinator(Class<? extends CompactionCoordinator> coordinator) throws IOException {
        if (this.coordinatorProcess == null) {
            this.coordinatorProcess = this.cluster._exec(coordinator, ServerType.COMPACTION_COORDINATOR, new HashMap<String, String>(), new String[0]).getProcess();
            TExternalCompactionList metrics = null;
            while (metrics == null) {
                try {
                    metrics = MiniAccumuloClusterControl.getRunningCompactions((ClientContext)this.cluster.getServerContext());
                }
                catch (TException e) {
                    log.debug("Error getting running compactions from coordinator, message: " + e.getMessage());
                    UtilWaitThread.sleep((long)250L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startCompactors(Class<? extends Compactor> compactor, int limit, String queueName) throws IOException {
        List<Process> list = this.compactorProcesses;
        synchronized (list) {
            int count = Math.min(limit, this.cluster.getConfig().getNumCompactors() - this.compactorProcesses.size());
            for (int i = 0; i < count; ++i) {
                this.compactorProcesses.add(this.cluster.exec(compactor, "-o", Property.COMPACTOR_QUEUE_NAME.getKey() + "=" + queueName).getProcess());
            }
        }
    }

    @Override
    public synchronized void startAllServers(ServerType server) throws IOException {
        this.start(server, null);
    }

    @Override
    public synchronized void start(ServerType server, String hostname) throws IOException {
        this.start(server, Collections.emptyMap(), Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(ServerType server, Map<String, String> configOverrides, int limit) throws IOException {
        if (limit <= 0) {
            return;
        }
        switch (server) {
            case TABLET_SERVER: {
                List<Process> list = this.tabletServerProcesses;
                synchronized (list) {
                    int count = 0;
                    for (int i = this.tabletServerProcesses.size(); count < limit && i < this.cluster.getConfig().getNumTservers(); ++i, ++count) {
                        this.tabletServerProcesses.add(this.cluster._exec(TabletServer.class, server, configOverrides, new String[0]).getProcess());
                    }
                    break;
                }
            }
            case MANAGER: {
                if (this.managerProcess != null) break;
                this.managerProcess = this.cluster._exec(Manager.class, server, configOverrides, new String[0]).getProcess();
                break;
            }
            case ZOOKEEPER: {
                if (this.zooKeeperProcess != null) break;
                this.zooKeeperProcess = this.cluster._exec(ZooKeeperServerMain.class, server, configOverrides, this.cluster.getZooCfgFile().getAbsolutePath()).getProcess();
                break;
            }
            case GARBAGE_COLLECTOR: {
                if (this.gcProcess != null) break;
                this.gcProcess = this.cluster._exec(SimpleGarbageCollector.class, server, configOverrides, new String[0]).getProcess();
                break;
            }
            case MONITOR: {
                if (this.monitor != null) break;
                this.monitor = this.cluster._exec(Monitor.class, server, configOverrides, new String[0]).getProcess();
                break;
            }
            case SCAN_SERVER: {
                List<Process> list = this.scanServerProcesses;
                synchronized (list) {
                    int count = 0;
                    for (int i = this.scanServerProcesses.size(); count < limit && i < this.cluster.getConfig().getNumScanServers(); ++i, ++count) {
                        this.scanServerProcesses.add(this.cluster._exec(ScanServer.class, server, configOverrides, new String[0]).getProcess());
                    }
                    break;
                }
            }
            case COMPACTION_COORDINATOR: {
                this.startCoordinator(CompactionCoordinator.class);
                break;
            }
            case COMPACTOR: {
                this.startCompactors(Compactor.class, this.cluster.getConfig().getNumCompactors(), configOverrides.get("QUEUE_NAME"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot start process for " + server);
            }
        }
    }

    @Override
    public synchronized void stopAllServers(ServerType server) throws IOException {
        this.stop(server);
    }

    public void stop(ServerType server) throws IOException {
        this.stop(server, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop(ServerType server, String hostname) throws IOException {
        switch (server) {
            case MANAGER: {
                if (this.managerProcess == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.managerProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Manager did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.managerProcess = null;
                }
            }
            case GARBAGE_COLLECTOR: {
                if (this.gcProcess == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.gcProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Garbage collector did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.gcProcess = null;
                }
            }
            case ZOOKEEPER: {
                if (this.zooKeeperProcess == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.zooKeeperProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("ZooKeeper did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.zooKeeperProcess = null;
                }
            }
            case TABLET_SERVER: {
                List<Process> e = this.tabletServerProcesses;
                synchronized (e) {
                    try {
                        for (Process tserver : this.tabletServerProcesses) {
                            try {
                                this.cluster.stopProcessWithTimeout(tserver, 30L, TimeUnit.SECONDS);
                            }
                            catch (ExecutionException | TimeoutException e2) {
                                log.warn("TabletServer did not fully stop after 30 seconds", (Throwable)e2);
                            }
                            catch (InterruptedException e3) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        break;
                    }
                    finally {
                        this.tabletServerProcesses.clear();
                    }
                }
            }
            case MONITOR: {
                if (this.monitor == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.monitor, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Monitor did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.monitor = null;
                }
            }
            case SCAN_SERVER: {
                List<Process> e = this.scanServerProcesses;
                synchronized (e) {
                    try {
                        for (Process sserver : this.scanServerProcesses) {
                            try {
                                this.cluster.stopProcessWithTimeout(sserver, 30L, TimeUnit.SECONDS);
                            }
                            catch (ExecutionException | TimeoutException e4) {
                                log.warn("ScanServer did not fully stop after 30 seconds", (Throwable)e4);
                            }
                            catch (InterruptedException e5) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        break;
                    }
                    finally {
                        this.scanServerProcesses.clear();
                    }
                }
            }
            case COMPACTION_COORDINATOR: {
                if (this.coordinatorProcess == null) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.coordinatorProcess, 30L, TimeUnit.SECONDS);
                    break;
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("CompactionCoordinator did not fully stop after 30 seconds", (Throwable)e);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    this.coordinatorProcess = null;
                }
            }
            case COMPACTOR: {
                List<Process> list = this.compactorProcesses;
                synchronized (list) {
                    try {
                        for (Process compactor : this.compactorProcesses) {
                            try {
                                this.cluster.stopProcessWithTimeout(compactor, 30L, TimeUnit.SECONDS);
                            }
                            catch (ExecutionException | TimeoutException e) {
                                log.warn("Compactor did not fully stop after 30 seconds", (Throwable)e);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        break;
                    }
                    finally {
                        this.compactorProcesses.clear();
                    }
                }
            }
            default: {
                throw new UnsupportedOperationException("ServerType is not yet supported " + server);
            }
        }
    }

    @Override
    public void signal(ServerType server, String hostname, String signal) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend(ServerType server, String hostname) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume(ServerType server, String hostname) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(ServerType type, ProcessReference procRef) throws ProcessNotFoundException, InterruptedException {
        boolean found = false;
        switch (type) {
            case MANAGER: {
                if (!procRef.getProcess().equals(this.managerProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.managerProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("Manager did not fully stop after 30 seconds", (Throwable)e);
                }
                this.managerProcess = null;
                found = true;
                break;
            }
            case TABLET_SERVER: {
                List<Process> e = this.tabletServerProcesses;
                synchronized (e) {
                    for (Process tserver : this.tabletServerProcesses) {
                        if (!procRef.getProcess().equals(tserver)) continue;
                        this.tabletServerProcesses.remove(tserver);
                        try {
                            this.cluster.stopProcessWithTimeout(tserver, 30L, TimeUnit.SECONDS);
                        }
                        catch (ExecutionException | TimeoutException e2) {
                            log.warn("TabletServer did not fully stop after 30 seconds", (Throwable)e2);
                        }
                        found = true;
                        break;
                    }
                    break;
                }
            }
            case ZOOKEEPER: {
                if (!procRef.getProcess().equals(this.zooKeeperProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.zooKeeperProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("ZooKeeper did not fully stop after 30 seconds", (Throwable)e);
                }
                this.zooKeeperProcess = null;
                found = true;
                break;
            }
            case GARBAGE_COLLECTOR: {
                if (!procRef.getProcess().equals(this.gcProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.gcProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("GarbageCollector did not fully stop after 30 seconds", (Throwable)e);
                }
                this.gcProcess = null;
                found = true;
                break;
            }
            case SCAN_SERVER: {
                List<Process> e = this.scanServerProcesses;
                synchronized (e) {
                    for (Process sserver : this.scanServerProcesses) {
                        if (!procRef.getProcess().equals(sserver)) continue;
                        this.scanServerProcesses.remove(sserver);
                        try {
                            this.cluster.stopProcessWithTimeout(sserver, 30L, TimeUnit.SECONDS);
                        }
                        catch (ExecutionException | TimeoutException e3) {
                            log.warn("ScanServer did not fully stop after 30 seconds", (Throwable)e3);
                        }
                        found = true;
                        break;
                    }
                    break;
                }
            }
            case COMPACTION_COORDINATOR: {
                if (!procRef.getProcess().equals(this.coordinatorProcess)) break;
                try {
                    this.cluster.stopProcessWithTimeout(this.coordinatorProcess, 30L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException e) {
                    log.warn("CompactionCoordinator did not fully stop after 30 seconds", (Throwable)e);
                }
                this.coordinatorProcess = null;
                found = true;
                break;
            }
            case COMPACTOR: {
                List<Process> list = this.compactorProcesses;
                synchronized (list) {
                    for (Process compactor : this.compactorProcesses) {
                        if (!procRef.getProcess().equals(compactor)) continue;
                        this.compactorProcesses.remove(compactor);
                        try {
                            this.cluster.stopProcessWithTimeout(compactor, 30L, TimeUnit.SECONDS);
                        }
                        catch (ExecutionException | TimeoutException e) {
                            log.warn("Compactor did not fully stop after 30 seconds", (Throwable)e);
                        }
                    }
                    break;
                }
            }
            default: {
                found = true;
            }
        }
        if (!found) {
            throw new ProcessNotFoundException();
        }
    }

    @Override
    public void kill(ServerType server, String hostname) throws IOException {
        this.stop(server, hostname);
    }
}

