/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.util;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.conf.store.impl.PropStoreWatcher;
import org.apache.accumulo.server.conf.store.impl.ReadyMonitor;
import org.apache.accumulo.server.conf.store.impl.ZooPropStore;
import org.apache.accumulo.server.conf.util.ZooInfoViewer;
import org.apache.accumulo.server.conf.util.ZooPropUtils;
import org.apache.accumulo.server.util.PropUtil;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class ZooPropEditor
implements KeywordExecutable {
    private static final Logger LOG = LoggerFactory.getLogger(ZooPropEditor.class);
    private final NullWatcher nullWatcher = new NullWatcher(new ReadyMonitor(ZooInfoViewer.class.getSimpleName(), 20000L));

    public String keyword() {
        return "zoo-prop-editor";
    }

    public String description() {
        return "Emergency tool to modify properties stored in ZooKeeper without a cluster. Prefer using the shell if it is available";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(ZooPropEditor.class.getName(), args, new Object[0]);
        ZooReaderWriter zrw = new ZooReaderWriter((AccumuloConfiguration)opts.getSiteConfiguration());
        SiteConfiguration siteConfig = opts.getSiteConfiguration();
        try (ServerContext context = new ServerContext(siteConfig);){
            InstanceId iid = context.getInstanceID();
            PropStoreKey<?> propKey = this.getPropKey(iid, opts, (ZooReader)zrw);
            switch (opts.getCmdMode()) {
                case SET: {
                    this.setProperty(context, propKey, opts);
                    return;
                }
                case DELETE: {
                    this.deleteProperty(context, propKey, this.readPropNode(propKey, (ZooReader)zrw), opts);
                    return;
                }
                case PRINT: {
                    this.printProperties(context, propKey, this.readPropNode(propKey, (ZooReader)zrw));
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Invalid operation requested");
                }
            }
        }
    }

    private void setProperty(ServerContext context, PropStoreKey<?> propKey, Opts opts) {
        LOG.trace("set {}", propKey);
        if (!opts.setOpt.contains("=")) {
            throw new IllegalArgumentException("Invalid set property format. Requires name=value, received " + opts.setOpt);
        }
        String targetName = "'invalid'";
        try {
            targetName = this.getDisplayName(propKey, context.getInstanceID(), context.getZooReader());
            Map<String, String> prev = context.getPropStore().get(propKey).asMap();
            String[] tokens = opts.setOpt.split("=");
            String propName = tokens[0].trim();
            String propVal = tokens[1].trim();
            Map<String, String> propMap = Map.of(propName, propVal);
            PropUtil.setProperties(context, propKey, propMap);
            if (prev.containsKey(propName)) {
                LOG.info("{}: modified {} from {} to {}", new Object[]{targetName, propName, prev.get(propName), propVal});
            } else {
                LOG.info("{}: set {}={}", new Object[]{targetName, propName, propVal});
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to set property for " + targetName + " (id: " + propKey.getId() + ")", ex);
        }
    }

    private void deleteProperty(ServerContext context, PropStoreKey<?> propKey, VersionedProperties versionedProperties, Opts opts) {
        LOG.trace("delete {} - {}", propKey, (Object)opts.deleteOpt);
        String p = opts.deleteOpt.trim();
        if (p.isEmpty() || !Property.isValidPropertyKey((String)p)) {
            throw new IllegalArgumentException("Invalid property name, Received: '" + p + "'");
        }
        if (!versionedProperties.asMap().containsKey(p)) {
            LOG.warn("skipping delete: property '{}' is not set for: {}- delete would have no effect", (Object)p, propKey);
            return;
        }
        PropUtil.removeProperties(context, propKey, List.of(p));
        String targetName = this.getDisplayName(propKey, context.getInstanceID(), context.getZooReader());
        LOG.info("{}: deleted {}", (Object)targetName, (Object)p);
    }

    private void printProperties(ServerContext context, PropStoreKey<?> propKey, VersionedProperties props) {
        LOG.trace("print {}", propKey);
        PrintStream outStream = System.out;
        String scope = propKey instanceof SystemPropKey ? "SYSTEM" : (propKey instanceof NamespacePropKey ? "NAMESPACE" : (propKey instanceof TablePropKey ? "TABLE" : "unknown"));
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8)));){
            writer.printf(": Instance name: %s\n", context.getInstanceName());
            writer.printf(": Instance Id: %s\n", context.getInstanceID());
            writer.printf(": Property scope: %s\n", scope);
            writer.printf(": ZooKeeper path: %s\n", propKey.getPath());
            writer.printf(": Name: %s\n", this.getDisplayName(propKey, context.getInstanceID(), context.getZooReader()));
            writer.printf(": Id: %s\n", propKey.getId());
            writer.printf(": Data version: %d\n", props.getDataVersion());
            writer.printf(": Timestamp: %s\n", props.getTimestampISO());
            if (props.asMap().isEmpty()) {
                return;
            }
            TreeMap<String, String> sortedMap = new TreeMap<String, String>(props.asMap());
            sortedMap.forEach((name, value) -> writer.printf("%s=%s\n", name, value));
        }
    }

    private VersionedProperties readPropNode(PropStoreKey<?> propKey, ZooReader zooReader) {
        try {
            return ZooPropStore.readFromZk(propKey, this.nullWatcher, zooReader);
        }
        catch (IOException | InterruptedException | KeeperException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private PropStoreKey<?> getPropKey(InstanceId iid, Opts opts, ZooReader zooReader) {
        if (!opts.tableOpt.isEmpty() || !opts.tableIdOpt.isEmpty()) {
            TableId tid = this.getTableId(iid, opts, zooReader);
            return TablePropKey.of(iid, tid);
        }
        if (!opts.namespaceOpt.isEmpty() || !opts.namespaceIdOpt.isEmpty()) {
            NamespaceId nid = this.getNamespaceId(iid, opts, zooReader);
            return NamespacePropKey.of(iid, nid);
        }
        return SystemPropKey.of(iid);
    }

    private TableId getTableId(InstanceId iid, Opts opts, ZooReader zooReader) {
        if (!opts.tableIdOpt.isEmpty()) {
            return TableId.of((String)opts.tableIdOpt);
        }
        Map<NamespaceId, String> nids = ZooPropUtils.getNamespaceIdToNameMap(iid, zooReader);
        Map<TableId, String> tids = ZooPropUtils.getTableIdToName(iid, nids, zooReader);
        return tids.entrySet().stream().filter(entry -> opts.tableOpt.equals(entry.getValue())).map(Map.Entry::getKey).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find table " + opts.tableOpt));
    }

    private NamespaceId getNamespaceId(InstanceId iid, Opts opts, ZooReader zooReader) {
        if (!opts.namespaceIdOpt.isEmpty()) {
            return NamespaceId.of((String)opts.namespaceIdOpt);
        }
        Map<NamespaceId, String> nids = ZooPropUtils.getNamespaceIdToNameMap(iid, zooReader);
        return nids.entrySet().stream().filter(entry -> opts.namespaceOpt.equals(entry.getValue())).map(Map.Entry::getKey).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find namespace " + opts.namespaceOpt));
    }

    private String getDisplayName(PropStoreKey<?> propStoreKey, InstanceId iid, ZooReader zooReader) {
        if (propStoreKey instanceof TablePropKey) {
            Map<NamespaceId, String> nids = ZooPropUtils.getNamespaceIdToNameMap(iid, zooReader);
            return ZooPropUtils.getTableIdToName(iid, nids, zooReader).getOrDefault((TableId)propStoreKey.getId(), "unknown");
        }
        if (propStoreKey instanceof NamespacePropKey) {
            return ZooPropUtils.getNamespaceIdToNameMap(iid, zooReader).getOrDefault((NamespaceId)propStoreKey.getId(), "unknown");
        }
        if (propStoreKey instanceof SystemPropKey) {
            return "system";
        }
        LOG.info("Undefined PropStoreKey type provided, cannot decode name for classname: {}", (Object)propStoreKey.getClass().getName());
        return "unknown";
    }

    private static class NullWatcher
    extends PropStoreWatcher {
        public NullWatcher(ReadyMonitor zkReadyMonitor) {
            super(zkReadyMonitor);
        }
    }

    static class Opts
    extends ConfigOpts {
        @Parameter(names={"-d", "--delete"}, description="delete a property")
        public String deleteOpt = "";
        @Parameter(names={"-ns", "--namespace"}, description="namespace to display/set/delete properties for")
        public String namespaceOpt = "";
        @Parameter(names={"-nid", "--namespace-id"}, description="namespace id to display/set/delete properties for")
        public String namespaceIdOpt = "";
        @Parameter(names={"-s", "--set"}, description="set a property")
        public String setOpt = "";
        @Parameter(names={"-t", "--table"}, description="table to display/set/delete properties for")
        public String tableOpt = "";
        @Parameter(names={"-tid", "--table-id"}, description="table id to display/set/delete properties for")
        public String tableIdOpt = "";

        Opts() {
        }

        public void parseArgs(String programName, String[] args, Object ... others) {
            super.parseArgs(programName, args, others);
            CmdMode cmdMode = this.getCmdMode();
            if (cmdMode == CmdMode.ERROR) {
                throw new IllegalArgumentException("Cannot use set and delete in one command");
            }
        }

        CmdMode getCmdMode() {
            if (!this.deleteOpt.isEmpty() && !this.setOpt.isEmpty()) {
                return CmdMode.ERROR;
            }
            if (!this.deleteOpt.isEmpty()) {
                return CmdMode.DELETE;
            }
            if (!this.setOpt.isEmpty()) {
                return CmdMode.SET;
            }
            return CmdMode.PRINT;
        }

        static enum CmdMode {
            ERROR,
            PRINT,
            SET,
            DELETE;

        }
    }
}

