/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.PropChangeListener;
import org.apache.accumulo.server.conf.store.PropStore;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropSnapshot
implements PropChangeListener {
    private static final Logger log = LoggerFactory.getLogger(PropSnapshot.class);
    private final Lock updateLock = new ReentrantLock();
    private final AtomicBoolean needsUpdate = new AtomicBoolean(true);
    private final AtomicReference<VersionedProperties> vPropRef = new AtomicReference();
    private final PropStoreKey<?> propStoreKey;
    private final PropStore propStore;

    public static PropSnapshot create(PropStoreKey<?> propStoreKey, PropStore propStore) {
        PropSnapshot ps = new PropSnapshot(propStoreKey, propStore);
        propStore.registerAsListener(propStoreKey, ps);
        return ps;
    }

    private PropSnapshot(PropStoreKey<?> propStoreKey, PropStore propStore) {
        this.propStoreKey = propStoreKey;
        this.propStore = propStore;
    }

    public @NonNull VersionedProperties getVersionedProperties() {
        this.updateSnapshot();
        VersionedProperties answer = this.vPropRef.get();
        if (answer == null) {
            throw new IllegalStateException("Invalid state for property snapshot, no value has been set");
        }
        return answer;
    }

    public void requireUpdate() {
        this.updateLock.lock();
        try {
            this.needsUpdate.set(true);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private void updateSnapshot() {
        if (!this.needsUpdate.get()) {
            return;
        }
        this.updateLock.lock();
        try {
            if (!this.needsUpdate.get()) {
                return;
            }
            VersionedProperties vProps = this.propStore.get(this.propStoreKey);
            this.vPropRef.set(vProps);
            this.needsUpdate.set(false);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    @Override
    public void zkChangeEvent(PropStoreKey<?> eventPropKey) {
        if (this.propStoreKey.equals(eventPropKey)) {
            this.requireUpdate();
        }
    }

    @Override
    public void cacheChangeEvent(PropStoreKey<?> eventPropKey) {
        if (this.propStoreKey.equals(eventPropKey)) {
            this.requireUpdate();
        }
    }

    @Override
    public void deleteEvent(PropStoreKey<?> eventPropKey) {
        if (this.propStoreKey.equals(eventPropKey)) {
            this.requireUpdate();
            log.debug("Received property delete event for {}", this.propStoreKey);
        }
    }

    @Override
    public void connectionEvent() {
        this.requireUpdate();
        log.debug("Received connection event - update properties required");
    }
}

