/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.codec;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.accumulo.server.conf.codec.EncodingOptions;
import org.apache.accumulo.server.conf.codec.VersionedPropCodec;
import org.apache.accumulo.server.conf.codec.VersionedProperties;

public class VersionedPropGzipCodec
extends VersionedPropCodec {
    private VersionedPropGzipCodec(EncodingOptions encodingOpts) {
        super(encodingOpts);
    }

    public static VersionedPropCodec codec(boolean compress) {
        return new VersionedPropGzipCodec(EncodingOptions.V1_0(compress));
    }

    @Override
    void encodePayload(OutputStream out, VersionedProperties vProps, EncodingOptions encodingOpts) throws IOException {
        block16: {
            Map<String, String> props = vProps.asMap();
            if (this.getEncodingOpts().isCompressed()) {
                try (GZIPOutputStream gzipOut = new GZIPOutputStream(out);
                     DataOutputStream zdos = new DataOutputStream(gzipOut);){
                    this.writeMapAsUTF(zdos, props);
                    gzipOut.flush();
                    gzipOut.finish();
                    break block16;
                }
            }
            try (DataOutputStream dos = new DataOutputStream(out);){
                this.writeMapAsUTF(dos, props);
            }
        }
    }

    @Override
    boolean checkCanDecodeVersion(EncodingOptions encodingOpts) {
        return encodingOpts.getEncodingVersion() == 1;
    }

    @Override
    Map<String, String> decodePayload(InputStream inStream, EncodingOptions encodingOpts) throws IOException {
        Map<String, String> aMap;
        block16: {
            if (encodingOpts.isCompressed()) {
                try (GZIPInputStream gzipIn = new GZIPInputStream(inStream);
                     DataInputStream zdis = new DataInputStream(gzipIn);){
                    aMap = this.readMapAsUTF(zdis);
                    break block16;
                }
            }
            try (DataInputStream dis = new DataInputStream(inStream);){
                aMap = this.readMapAsUTF(dis);
            }
        }
        return aMap;
    }
}

