/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.util.Set;
import org.apache.accumulo.server.ServerContext;

public class AccumuloDataVersion {
    public static final int REMOVE_DEPRECATIONS_FOR_VERSION_3 = 11;
    public static final int ROOT_TABLET_META_CHANGES = 10;
    private static final int CURRENT_VERSION = 11;
    public static final Set<Integer> CAN_RUN = Set.of(Integer.valueOf(10), Integer.valueOf(11));

    public static int get() {
        return 11;
    }

    public static int getCurrentVersion(ServerContext context) {
        int cv = context.getServerDirs().getAccumuloPersistentVersion(context.getVolumeManager().getFirst());
        ServerContext.ensureDataVersionCompatible(cv);
        return cv;
    }

    public static String oldestUpgradeableVersionName() {
        return AccumuloDataVersion.dataVersionToReleaseName(CAN_RUN.stream().mapToInt(x -> x).min().orElseThrow());
    }

    private static String dataVersionToReleaseName(int version) {
        switch (version) {
            case 10: {
                return "2.1.0";
            }
            case 11: {
                return "3.0.0";
            }
        }
        throw new IllegalArgumentException("Unsupported data version " + version);
    }
}

