/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.mem.LowMemoryDetector;
import org.apache.accumulo.server.metrics.ProcessMetrics;
import org.apache.accumulo.server.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
implements AutoCloseable,
MetricsProducer,
Runnable {
    private final ServerContext context;
    protected final String applicationName;
    private final String hostname;
    private final ProcessMetrics processMetrics;

    protected AbstractServer(String appName, ConfigOpts opts, String[] args) {
        this.applicationName = appName;
        opts.parseArgs(appName, args, new Object[0]);
        SiteConfiguration siteConfig = opts.getSiteConfiguration();
        this.hostname = siteConfig.get(Property.GENERAL_PROCESS_BIND_ADDRESS);
        SecurityUtil.serverLogin((AccumuloConfiguration)siteConfig);
        this.context = new ServerContext(siteConfig);
        Logger log = LoggerFactory.getLogger(this.getClass());
        log.info("Version 3.0.0");
        log.info("Instance " + this.context.getInstanceID());
        this.context.init(appName);
        ClassLoaderUtil.initContextFactory((AccumuloConfiguration)this.context.getConfiguration());
        TraceUtil.initializeTracer((AccumuloConfiguration)this.context.getConfiguration());
        if (this.context.getSaslParams() != null) {
            this.context.enforceKerberosLogin();
        }
        LowMemoryDetector lmd = this.context.getLowMemoryDetector();
        ScheduledFuture<?> future = this.context.getScheduledExecutor().scheduleWithFixedDelay(() -> lmd.logGCInfo(this.context.getConfiguration()), 0L, lmd.getIntervalMillis(this.context.getConfiguration()), TimeUnit.MILLISECONDS);
        ThreadPools.watchNonCriticalScheduledTask(future);
        this.processMetrics = new ProcessMetrics(this.context);
    }

    public void runServer() throws Exception {
        AtomicReference err = new AtomicReference();
        Thread service = new Thread(TraceUtil.wrap((Runnable)this), this.applicationName);
        service.setUncaughtExceptionHandler((thread, exception) -> err.set(exception));
        service.start();
        service.join();
        Throwable thrown = (Throwable)err.get();
        if (thrown != null) {
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            if (thrown instanceof Exception) {
                throw (Exception)thrown;
            }
            throw new IllegalStateException("Weird throwable type thrown", thrown);
        }
    }

    public void registerMetrics(MeterRegistry registry) {
        if (this.processMetrics != null) {
            this.processMetrics.registerMetrics(registry);
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public ServerContext getContext() {
        return this.context;
    }

    public AccumuloConfiguration getConfiguration() {
        return this.getContext().getConfiguration();
    }

    @Override
    public void close() {
        MetricsUtil.close();
    }
}

