/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.Scanner;

public class SingleScanSession
extends ScanSession {
    public final KeyExtent extent;
    public final AtomicBoolean interruptFlag = new AtomicBoolean();
    public long entriesReturned = 0L;
    public long batchCount = 0L;
    public volatile ScanTask<ScanBatch> nextBatchTask;
    public Scanner scanner;
    public final long readaheadThreshold;

    public SingleScanSession(TCredentials credentials, KeyExtent extent, ScanParameters scanParams, long readaheadThreshold, Map<String, String> executionHints, ScanSession.TabletResolver tabletResolver) {
        super(credentials, scanParams, executionHints, tabletResolver);
        this.extent = extent;
        this.readaheadThreshold = readaheadThreshold;
    }

    public ScanInfo.Type getScanType() {
        return ScanInfo.Type.SINGLE;
    }

    public TableId getTableId() {
        return this.extent.tableId();
    }

    @Override
    public boolean cleanup() {
        boolean ret;
        try {
            if (this.nextBatchTask != null) {
                this.nextBatchTask.cancel(true);
            }
        }
        finally {
            ret = this.scanner != null ? this.scanner.close() : true;
        }
        return ret;
    }
}

