/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Uninterruptibles;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.DurabilityImpl;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheConfiguration;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.lock.ServiceLockData;
import org.apache.accumulo.core.manager.thrift.BulkImportState;
import org.apache.accumulo.core.manager.thrift.Compacting;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.manager.thrift.TableInfo;
import org.apache.accumulo.core.manager.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.apache.accumulo.core.tablet.thrift.TabletManagementClientService;
import org.apache.accumulo.core.tabletingest.thrift.TabletIngestClientService;
import org.apache.accumulo.core.tabletscan.thrift.TabletScanClientService;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.TabletServerClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.ComparablePair;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.Retry;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.TabletLevel;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.compaction.CompactionWatcher;
import org.apache.accumulo.server.compaction.PausedCompactionMetrics;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeChooserEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.manager.recovery.RecoveryPath;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.security.delegation.ZooAuthenticationKeyWatcher;
import org.apache.accumulo.server.util.ServerBulkImportStatus;
import org.apache.accumulo.server.util.time.RelativeTime;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.tserver.BulkFailedCopyProcessor;
import org.apache.accumulo.tserver.BusiestTracker;
import org.apache.accumulo.tserver.OnlineTablets;
import org.apache.accumulo.tserver.TabletClientHandler;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.ThriftScanClientHandler;
import org.apache.accumulo.tserver.WriteTracker;
import org.apache.accumulo.tserver.compactions.CompactionManager;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.LogSorter;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.log.TabletServerLogger;
import org.apache.accumulo.tserver.managermessage.ManagerMessage;
import org.apache.accumulo.tserver.managermessage.SplitReportMessage;
import org.apache.accumulo.tserver.metrics.CompactionExecutorsMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerMinCMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerUpdateMetrics;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.session.SessionManager;
import org.apache.accumulo.tserver.tablet.BulkImportCacheCleaner;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.MetadataUpdateCount;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletData;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.server.TServer;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServer
extends AbstractServer
implements TabletHostingServer {
    private static final Logger log = LoggerFactory.getLogger(TabletServer.class);
    private static final long TIME_BETWEEN_LOCATOR_CACHE_CLEARS = TimeUnit.HOURS.toMillis(1L);
    final ZooCache managerLockCache;
    final TabletServerLogger logger;
    private TabletServerMetrics metrics;
    TabletServerUpdateMetrics updateMetrics;
    TabletServerScanMetrics scanMetrics;
    TabletServerMinCMetrics mincMetrics;
    CompactionExecutorsMetrics ceMetrics;
    PausedCompactionMetrics pausedMetrics;
    private final LogSorter logSorter;
    final TabletStatsKeeper statsKeeper;
    private final AtomicInteger logIdGenerator = new AtomicInteger();
    private final AtomicLong flushCounter = new AtomicLong(0L);
    private final AtomicLong syncCounter = new AtomicLong(0L);
    final OnlineTablets onlineTablets = new OnlineTablets();
    final SortedSet<KeyExtent> unopenedTablets = Collections.synchronizedSortedSet(new TreeSet());
    final SortedSet<KeyExtent> openingTablets = Collections.synchronizedSortedSet(new TreeSet());
    final Map<KeyExtent, Long> recentlyUnloadedCache = Collections.synchronizedMap(new LRUMap(1000));
    final TabletServerResourceManager resourceManager;
    private final SecurityOperation security;
    private final BlockingDeque<ManagerMessage> managerMessages = new LinkedBlockingDeque<ManagerMessage>();
    volatile HostAndPort clientAddress;
    private volatile boolean serverStopRequested = false;
    private volatile boolean shutdownComplete = false;
    private ServiceLock tabletServerLock;
    private TServer server;
    private DistributedWorkQueue bulkFailedCopyQ;
    private String lockID;
    private volatile long lockSessionId = -1L;
    public static final AtomicLong seekCount = new AtomicLong(0L);
    private final AtomicLong totalMinorCompactions = new AtomicLong(0L);
    private final ZooAuthenticationKeyWatcher authKeyWatcher;
    private final WalStateManager walMarker;
    private final ServerContext context;
    final SessionManager sessionManager;
    private final AtomicLong totalQueuedMutationSize = new AtomicLong(0L);
    private final ReentrantLock recoveryLock = new ReentrantLock(true);
    private ClientServiceHandler clientHandler;
    private TabletClientHandler thriftClientHandler;
    private ThriftScanClientHandler scanClientHandler;
    private final ServerBulkImportStatus bulkImportStatus = new ServerBulkImportStatus();
    private CompactionManager compactionManager;
    final ConcurrentHashMap<DfsLogger, EnumSet<TabletLevel>> metadataTableLogs = new ConcurrentHashMap();
    final LinkedHashSet<DfsLogger> closedLogs = new LinkedHashSet();

    @Override
    public TabletServerScanMetrics getScanMetrics() {
        return this.scanMetrics;
    }

    public TabletServerMinCMetrics getMinCMetrics() {
        return this.mincMetrics;
    }

    @Override
    public PausedCompactionMetrics getPausedCompactionMetrics() {
        return this.pausedMetrics;
    }

    public static void main(String[] args) throws Exception {
        try (TabletServer tserver = new TabletServer(new ConfigOpts(), args);){
            tserver.runServer();
        }
    }

    protected TabletServer(ConfigOpts opts, String[] args) {
        super("tserver", opts, args);
        ScheduledFuture<?> future;
        this.context = super.getContext();
        this.managerLockCache = new ZooCache(this.context.getZooReader(), null);
        AccumuloConfiguration aconf = this.getConfiguration();
        log.info("Version 3.0.0");
        log.info("Instance " + this.getInstanceID());
        this.sessionManager = new SessionManager(this.context);
        this.logSorter = new LogSorter(this.context, aconf);
        this.statsKeeper = new TabletStatsKeeper();
        final int numBusyTabletsToLog = aconf.getCount(Property.TSERV_LOG_BUSY_TABLETS_COUNT);
        long logBusyTabletsDelay = aconf.getTimeInMillis(Property.TSERV_LOG_BUSY_TABLETS_INTERVAL);
        TabletServer.checkWalCanSync(this.context);
        if (numBusyTabletsToLog > 0) {
            future = this.context.getScheduledExecutor().scheduleWithFixedDelay(Threads.createNamedRunnable((String)"BusyTabletLogger", (Runnable)new Runnable(){
                private BusiestTracker ingestTracker;
                private BusiestTracker queryTracker;
                {
                    this.ingestTracker = BusiestTracker.newBusiestIngestTracker(numBusyTabletsToLog);
                    this.queryTracker = BusiestTracker.newBusiestQueryTracker(numBusyTabletsToLog);
                }

                @Override
                public void run() {
                    Collection<Tablet> tablets = TabletServer.this.onlineTablets.snapshot().values();
                    this.logBusyTablets(this.ingestTracker.computeBusiest(tablets), "ingest count");
                    this.logBusyTablets(this.queryTracker.computeBusiest(tablets), "query count");
                }

                private void logBusyTablets(List<ComparablePair<Long, KeyExtent>> busyTablets, String label) {
                    int i = 1;
                    for (Pair pair : busyTablets) {
                        log.debug("{} busiest tablet by {}: {} -- extent: {} ", new Object[]{i, label.toLowerCase(), pair.getFirst(), pair.getSecond()});
                        ++i;
                    }
                }
            }), logBusyTabletsDelay, logBusyTabletsDelay, TimeUnit.MILLISECONDS);
            ThreadPools.watchNonCriticalScheduledTask(future);
        }
        future = this.context.getScheduledExecutor().scheduleWithFixedDelay(Threads.createNamedRunnable((String)"TabletRateUpdater", () -> {
            long now = System.currentTimeMillis();
            for (Tablet tablet : this.getOnlineTablets().values()) {
                try {
                    tablet.updateRates(now);
                }
                catch (Exception ex) {
                    log.error("Error updating rates for {}", (Object)tablet.getExtent(), (Object)ex);
                }
            }
        }), 5L, 5L, TimeUnit.SECONDS);
        ThreadPools.watchNonCriticalScheduledTask(future);
        long walMaxSize = aconf.getAsBytes(Property.TSERV_WAL_MAX_SIZE);
        long walMaxAge = aconf.getTimeInMillis(Property.TSERV_WAL_MAX_AGE);
        long minBlockSize = this.context.getHadoopConf().getLong("dfs.namenode.fs-limits.min-block-size", 0L);
        if (minBlockSize != 0L && minBlockSize > walMaxSize) {
            throw new RuntimeException("Unable to start TabletServer. Logger is set to use blocksize " + walMaxSize + " but hdfs minimum block size is " + minBlockSize + ". Either increase the " + Property.TSERV_WAL_MAX_SIZE + " or decrease dfs.namenode.fs-limits.min-block-size in hdfs-site.xml.");
        }
        long toleratedWalCreationFailures = aconf.getCount(Property.TSERV_WAL_TOLERATED_CREATION_FAILURES);
        long walFailureRetryIncrement = aconf.getTimeInMillis(Property.TSERV_WAL_TOLERATED_WAIT_INCREMENT);
        long walFailureRetryMax = aconf.getTimeInMillis(Property.TSERV_WAL_TOLERATED_MAXIMUM_WAIT_DURATION);
        Retry.RetryFactory walCreationRetryFactory = Retry.builder().maxRetries(toleratedWalCreationFailures).retryAfter(walFailureRetryIncrement, TimeUnit.MILLISECONDS).incrementBy(walFailureRetryIncrement, TimeUnit.MILLISECONDS).maxWait(walFailureRetryMax, TimeUnit.MILLISECONDS).backOffFactor(1.5).logInterval(3L, TimeUnit.MINUTES).createFactory();
        Retry.RetryFactory walWritingRetryFactory = Retry.builder().infiniteRetries().retryAfter(walFailureRetryIncrement, TimeUnit.MILLISECONDS).incrementBy(walFailureRetryIncrement, TimeUnit.MILLISECONDS).maxWait(walFailureRetryMax, TimeUnit.MILLISECONDS).backOffFactor(1.5).logInterval(3L, TimeUnit.MINUTES).createFactory();
        this.logger = new TabletServerLogger(this, walMaxSize, this.syncCounter, this.flushCounter, walCreationRetryFactory, walWritingRetryFactory, walMaxAge);
        this.resourceManager = new TabletServerResourceManager(this.context, this);
        this.security = this.context.getSecurityOperation();
        ThreadPools.watchCriticalScheduledTask(this.context.getScheduledExecutor().scheduleWithFixedDelay(TabletLocator::clearLocators, TabletServer.jitter(), TabletServer.jitter(), TimeUnit.MILLISECONDS));
        this.walMarker = new WalStateManager(this.context);
        if (aconf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            log.info("SASL is enabled, creating ZooKeeper watcher for AuthenticationKeys");
            this.authKeyWatcher = new ZooAuthenticationKeyWatcher(this.context.getSecretManager(), (ZooReader)this.context.getZooReaderWriter(), this.context.getZooKeeperRoot() + "/delegation_token_keys");
        } else {
            this.authKeyWatcher = null;
        }
        this.config();
    }

    public InstanceId getInstanceID() {
        return this.getContext().getInstanceID();
    }

    public String getVersion() {
        return "3.0.0";
    }

    private static long jitter() {
        return (long)((1.0 + ((SecureRandom)LazySingletons.RANDOM.get()).nextDouble() / 10.0) * (double)TIME_BETWEEN_LOCATOR_CACHE_CLEARS);
    }

    String getLockID() {
        return this.lockID;
    }

    void requestStop() {
        log.info("Stop requested.");
        this.serverStopRequested = true;
    }

    public long updateTotalQueuedMutationSize(long additionalMutationSize) {
        return this.totalQueuedMutationSize.addAndGet(additionalMutationSize);
    }

    @Override
    public Session getSession(long sessionId) {
        return this.sessionManager.getSession(sessionId);
    }

    public void executeSplit(Tablet tablet) {
        this.resourceManager.executeSplit(tablet.getExtent(), new SplitRunner(tablet));
    }

    private void splitTablet(Tablet tablet) {
        try {
            this.splitTablet(tablet, null);
        }
        catch (IOException e) {
            this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, 0L, true);
            log.error("split failed: {} for tablet {}", new Object[]{e.getMessage(), tablet.getExtent(), e});
        }
        catch (Exception e) {
            this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, 0L, true);
            log.error("Unknown error on split:", (Throwable)e);
        }
    }

    TreeMap<KeyExtent, TabletData> splitTablet(Tablet tablet, byte[] splitPoint) throws IOException {
        long t1 = System.currentTimeMillis();
        TreeMap<KeyExtent, TabletData> tabletInfo = tablet.split(splitPoint);
        if (tabletInfo == null) {
            return null;
        }
        log.info("Starting split: {}", (Object)tablet.getExtent());
        this.statsKeeper.incrementStatusSplit();
        long start = System.currentTimeMillis();
        Tablet[] newTablets = new Tablet[2];
        Map.Entry<KeyExtent, TabletData> first = tabletInfo.firstEntry();
        TabletServerResourceManager.TabletResourceManager newTrm0 = this.resourceManager.createTabletResourceManager(first.getKey(), (AccumuloConfiguration)this.getTableConfiguration(first.getKey()));
        newTablets[0] = new Tablet(this, first.getKey(), newTrm0, first.getValue());
        Map.Entry<KeyExtent, TabletData> last = tabletInfo.lastEntry();
        TabletServerResourceManager.TabletResourceManager newTrm1 = this.resourceManager.createTabletResourceManager(last.getKey(), (AccumuloConfiguration)this.getTableConfiguration(last.getKey()));
        newTablets[1] = new Tablet(this, last.getKey(), newTrm1, last.getValue());
        this.statsKeeper.saveMajorMinorTimes(tablet.getTabletStats());
        this.onlineTablets.split(tablet.getExtent(), newTablets[0], newTablets[1]);
        this.enqueueManagerMessage(new SplitReportMessage(tablet.getExtent(), newTablets[0].getExtent(), new Text("/" + newTablets[0].getDirName()), newTablets[1].getExtent(), new Text("/" + newTablets[1].getDirName())));
        this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, start, false);
        long t2 = System.currentTimeMillis();
        log.info("Tablet split: {} size0 {} size1 {} time {}ms", new Object[]{tablet.getExtent(), newTablets[0].estimateTabletSize(), newTablets[1].estimateTabletSize(), t2 - t1});
        return tabletInfo;
    }

    public void enqueueManagerMessage(ManagerMessage m) {
        this.managerMessages.addLast(m);
    }

    void acquireRecoveryMemory(KeyExtent extent) {
        if (!extent.isMeta()) {
            this.recoveryLock.lock();
        }
    }

    void releaseRecoveryMemory(KeyExtent extent) {
        if (!extent.isMeta()) {
            this.recoveryLock.unlock();
        }
    }

    private HostAndPort startServer(AccumuloConfiguration conf, String address, TProcessor processor) throws UnknownHostException {
        Property maxMessageSizeProperty = conf.get(Property.TSERV_MAX_MESSAGE_SIZE) != null ? Property.TSERV_MAX_MESSAGE_SIZE : Property.GENERAL_MAX_MESSAGE_SIZE;
        ServerAddress sp = TServerUtils.startServer((ServerContext)this.getContext(), (String)address, (Property)Property.TSERV_CLIENTPORT, (TProcessor)processor, (String)this.getClass().getSimpleName(), (String)"Thrift Client Server", (Property)Property.TSERV_PORTSEARCH, (Property)Property.TSERV_MINTHREADS, (Property)Property.TSERV_MINTHREADS_TIMEOUT, (Property)Property.TSERV_THREADCHECK, (Property)maxMessageSizeProperty);
        this.server = sp.server;
        return sp.address;
    }

    private HostAndPort getManagerAddress() {
        try {
            List locations = this.getContext().getManagerLocations();
            if (locations.isEmpty()) {
                return null;
            }
            return HostAndPort.fromString((String)((String)locations.get(0)));
        }
        catch (Exception e) {
            log.warn("Failed to obtain manager host " + e);
            return null;
        }
    }

    private ManagerClientService.Client managerConnection(HostAndPort address) {
        try {
            if (address == null) {
                return null;
            }
            return (ManagerClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.MANAGER, (HostAndPort)address, (ClientContext)this.getContext());
        }
        catch (Exception e) {
            log.warn("Issue with managerConnection (" + address + ") " + e, (Throwable)e);
            return null;
        }
    }

    protected ClientServiceHandler newClientHandler(TransactionWatcher watcher) {
        return new ClientServiceHandler(this.context, watcher);
    }

    protected TabletClientHandler newTabletClientHandler(TransactionWatcher watcher, WriteTracker writeTracker) {
        return new TabletClientHandler(this, watcher, writeTracker);
    }

    protected ThriftScanClientHandler newThriftScanClientHandler(WriteTracker writeTracker) {
        return new ThriftScanClientHandler(this, writeTracker);
    }

    private void returnManagerConnection(ManagerClientService.Client client) {
        ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.context);
    }

    private HostAndPort startTabletClientService() throws UnknownHostException {
        TransactionWatcher watcher = new TransactionWatcher(this.context);
        WriteTracker writeTracker = new WriteTracker();
        this.clientHandler = this.newClientHandler(watcher);
        this.thriftClientHandler = this.newTabletClientHandler(watcher, writeTracker);
        this.scanClientHandler = this.newThriftScanClientHandler(writeTracker);
        TMultiplexedProcessor processor = ThriftProcessorTypes.getTabletServerTProcessor((ClientServiceHandler)this.clientHandler, (TabletServerClientService.Iface)this.thriftClientHandler, (TabletScanClientService.Iface)this.scanClientHandler, (TabletIngestClientService.Iface)this.thriftClientHandler, (TabletManagementClientService.Iface)this.thriftClientHandler, (ServerContext)this.getContext());
        HostAndPort address = this.startServer(this.getConfiguration(), this.clientAddress.getHost(), (TProcessor)processor);
        log.info("address = {}", (Object)address);
        return address;
    }

    @Override
    public ServiceLock getLock() {
        return this.tabletServerLock;
    }

    @Override
    public ZooCache getManagerLockCache() {
        return this.managerLockCache;
    }

    private void announceExistence() {
        ZooReaderWriter zoo = this.getContext().getZooReaderWriter();
        try {
            ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(this.getContext().getZooKeeperRoot() + "/tservers/" + this.getClientAddressString()));
            try {
                zoo.putPersistentData(zLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NOAUTH) {
                    log.error("Failed to write to ZooKeeper. Ensure that accumulo.properties, specifically instance.secret, is consistent.");
                }
                throw e;
            }
            UUID tabletServerUUID = UUID.randomUUID();
            this.tabletServerLock = new ServiceLock(zoo.getZooKeeper(), zLockPath, tabletServerUUID);
            ServiceLock.LockWatcher lw = new ServiceLock.LockWatcher(){

                public void lostLock(ServiceLock.LockLossReason reason) {
                    Halt.halt((int)(TabletServer.this.serverStopRequested ? 0 : 1), () -> {
                        if (!TabletServer.this.serverStopRequested) {
                            log.error("Lost tablet server lock (reason = {}), exiting.", (Object)reason);
                        }
                        TabletServer.this.context.getLowMemoryDetector().logGCInfo(TabletServer.this.getConfiguration());
                    });
                }

                public void unableToMonitorLockNode(Exception e) {
                    Halt.halt((int)1, () -> log.error("Lost ability to monitor tablet server lock, exiting.", (Throwable)e));
                }
            };
            for (int i = 0; i < 24; ++i) {
                zoo.putPersistentData(zLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                ServiceLockData.ServiceDescriptors descriptors = new ServiceLockData.ServiceDescriptors();
                for (ServiceLockData.ThriftService svc : new ServiceLockData.ThriftService[]{ServiceLockData.ThriftService.CLIENT, ServiceLockData.ThriftService.TABLET_INGEST, ServiceLockData.ThriftService.TABLET_MANAGEMENT, ServiceLockData.ThriftService.TABLET_SCAN, ServiceLockData.ThriftService.TSERV}) {
                    descriptors.addService(new ServiceLockData.ServiceDescriptor(tabletServerUUID, svc, this.getClientAddressString()));
                }
                if (this.tabletServerLock.tryLock(lw, new ServiceLockData(descriptors))) {
                    this.lockID = this.tabletServerLock.getLockID().serialize(this.getContext().getZooKeeperRoot() + "/tservers/");
                    this.lockSessionId = this.tabletServerLock.getSessionId();
                    log.debug("Obtained tablet server lock {} {}", (Object)this.tabletServerLock.getLockPath(), (Object)this.getTabletSession());
                    return;
                }
                log.info("Waiting for tablet server lock");
                Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            String msg = "Too many retries, exiting.";
            log.info(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.info("Could not obtain tablet server lock, exiting.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SecurityUtil.serverLogin((AccumuloConfiguration)this.getConfiguration());
        if (this.authKeyWatcher != null) {
            log.info("Seeding ZooKeeper watcher for authentication keys");
            try {
                this.authKeyWatcher.updateAuthKeys();
            }
            catch (InterruptedException | KeeperException e) {
                log.error("Failed to perform initial check for authentication tokens in ZooKeeper. Delegation token authentication will be unavailable.", e);
            }
        }
        try {
            this.clientAddress = this.startTabletClientService();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException("Failed to start the tablet client service", e1);
        }
        try {
            MetricsUtil.initializeMetrics((AccumuloConfiguration)this.context.getConfiguration(), (String)this.applicationName, (HostAndPort)this.clientAddress);
            this.metrics = new TabletServerMetrics(this);
            this.updateMetrics = new TabletServerUpdateMetrics();
            this.scanMetrics = new TabletServerScanMetrics();
            this.mincMetrics = new TabletServerMinCMetrics();
            this.ceMetrics = new CompactionExecutorsMetrics();
            this.pausedMetrics = new PausedCompactionMetrics();
            MetricsUtil.initializeProducers((MetricsProducer[])new MetricsProducer[]{this, this.metrics, this.updateMetrics, this.scanMetrics, this.mincMetrics, this.ceMetrics, this.pausedMetrics});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            log.error("Error initializing metrics, metrics will not be emitted.", (Throwable)e1);
        }
        this.compactionManager = new CompactionManager(() -> Iterators.transform(this.onlineTablets.snapshot().values().iterator(), Tablet::asCompactable), this.getContext(), this.ceMetrics);
        this.compactionManager.start();
        this.announceExistence();
        try {
            this.walMarker.initWalMarker(this.getTabletSession());
        }
        catch (Exception e) {
            log.error("Unable to create WAL marker node in zookeeper", (Throwable)e);
            throw new RuntimeException(e);
        }
        ThreadPoolExecutor distWorkQThreadPool = ThreadPools.getServerThreadPools().createExecutorService(this.getConfiguration(), Property.TSERV_WORKQ_THREADS, true);
        this.bulkFailedCopyQ = new DistributedWorkQueue(this.getContext().getZooKeeperRoot() + "/bulk_failed_copyq", this.getConfiguration(), this.getContext());
        try {
            this.bulkFailedCopyQ.startProcessing((DistributedWorkQueue.Processor)new BulkFailedCopyProcessor(this.getContext()), distWorkQThreadPool);
        }
        catch (Exception e1) {
            throw new RuntimeException("Failed to start distributed work queue for copying ", e1);
        }
        try {
            this.logSorter.startWatchingForRecoveryLogs(distWorkQThreadPool);
        }
        catch (Exception ex) {
            log.error("Error setting watches for recoveries");
            throw new RuntimeException(ex);
        }
        AccumuloConfiguration aconf = this.getConfiguration();
        long tabletCheckFrequency = aconf.getTimeInMillis(Property.TSERV_HEALTH_CHECK_FREQ);
        ThreadPools.watchCriticalFixedDelay((AccumuloConfiguration)aconf, (long)tabletCheckFrequency, () -> {
            SortedMap<KeyExtent, Tablet> onlineTabletsSnapshot = this.onlineTablets.snapshot();
            HashMap updateCounts = new HashMap();
            onlineTabletsSnapshot.forEach((ke, tablet) -> updateCounts.put(ke, tablet.getUpdateCount()));
            Instant start = Instant.now();
            Span mdScanSpan = TraceUtil.startSpan(this.getClass(), (String)"metadataScan");
            try (Scope scope = mdScanSpan.makeCurrent();){
                ArrayList missingTablets = new ArrayList();
                try (TabletsMetadata tabletsMetadata = this.getContext().getAmple().readTablets().forTablets(onlineTabletsSnapshot.keySet(), Optional.of(missingTablets::add)).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.LOGS, TabletMetadata.ColumnType.ECOMP, TabletMetadata.ColumnType.PREV_ROW}).build();){
                    Duration duration = Duration.between(start, Instant.now());
                    log.debug("Metadata scan took {}ms for {} tablets read.", (Object)duration.toMillis(), (Object)onlineTabletsSnapshot.keySet().size());
                    for (TabletMetadata tabletMetadata : tabletsMetadata) {
                        KeyExtent extent = tabletMetadata.getExtent();
                        Tablet tablet2 = (Tablet)onlineTabletsSnapshot.get(extent);
                        MetadataUpdateCount counter = (MetadataUpdateCount)updateCounts.get(extent);
                        tablet2.compareTabletInfo(counter, tabletMetadata);
                    }
                    for (KeyExtent extent : missingTablets) {
                        Tablet tablet3 = (Tablet)onlineTabletsSnapshot.get(extent);
                        if (tablet3.isClosed()) continue;
                        log.error("Tablet {} is open but does not exist in metadata table.", (Object)extent);
                    }
                }
            }
            catch (Exception e) {
                log.error("Unable to complete verification of tablet metadata", (Throwable)e);
                TraceUtil.setException((Span)mdScanSpan, (Throwable)e, (boolean)true);
            }
            finally {
                mdScanSpan.end();
            }
        });
        long CLEANUP_BULK_LOADED_CACHE_MILLIS = TimeUnit.MINUTES.toMillis(15L);
        ThreadPools.watchCriticalScheduledTask(this.context.getScheduledExecutor().scheduleWithFixedDelay(new BulkImportCacheCleaner(this), CLEANUP_BULK_LOADED_CACHE_MILLIS, CLEANUP_BULK_LOADED_CACHE_MILLIS, TimeUnit.MILLISECONDS));
        while (!this.serverStopRequested) {
            try {
                ManagerClientService.Client iface;
                block35: {
                    ManagerMessage mm = null;
                    iface = null;
                    try {
                        while (mm == null && !this.serverStopRequested) {
                            mm = this.managerMessages.poll(1L, TimeUnit.SECONDS);
                        }
                        HostAndPort managerHost = this.getManagerAddress();
                        ManagerClientService.Client client = iface = this.managerConnection(managerHost);
                        while (!this.serverStopRequested && mm != null && client != null && client.getOutputProtocol() != null && client.getOutputProtocol().getTransport() != null && client.getOutputProtocol().getTransport().isOpen()) {
                            try {
                                mm.send(this.getContext().rpcCreds(), this.getClientAddressString(), (ManagerClientService.Iface)iface);
                                mm = null;
                            }
                            catch (TException ex) {
                                log.warn("Error sending message: queuing message again");
                                this.managerMessages.putFirst(mm);
                                mm = null;
                                throw ex;
                            }
                            mm = this.managerMessages.poll();
                        }
                        if (mm == null) break block35;
                    }
                    catch (Throwable throwable) {
                        if (mm != null) {
                            this.managerMessages.putFirst(mm);
                        }
                        this.returnManagerConnection(iface);
                        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                        throw throwable;
                    }
                    this.managerMessages.putFirst(mm);
                }
                this.returnManagerConnection(iface);
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.info("Interrupt Exception received, shutting down");
                this.serverStopRequested = true;
            }
            catch (Exception e) {
                log.error(this.getClientAddressString() + ": TServerInfo: Exception. Manager down?", (Throwable)e);
            }
        }
        TabletServer e = this;
        synchronized (e) {
            while (!this.shutdownComplete) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e2) {
                    log.error(e2.toString());
                }
            }
        }
        log.debug("Stopping Thrift Servers");
        if (this.server != null) {
            this.server.stop();
        }
        try {
            log.debug("Closing filesystems");
            this.getVolumeManager().close();
        }
        catch (IOException e2) {
            log.warn("Failed to close filesystem : {}", (Object)e2.getMessage(), (Object)e2);
        }
        this.context.getLowMemoryDetector().logGCInfo(this.getConfiguration());
        log.info("TServerInfo: stop requested. exiting ... ");
        try {
            this.tabletServerLock.unlock();
        }
        catch (Exception e3) {
            log.warn("Failed to release tablet server lock", (Throwable)e3);
        }
    }

    public String getClientAddressString() {
        if (this.clientAddress == null) {
            return null;
        }
        return this.clientAddress.getHost() + ":" + this.clientAddress.getPort();
    }

    public TServerInstance getTabletSession() {
        String address = this.getClientAddressString();
        if (address == null) {
            return null;
        }
        if (this.lockSessionId == -1L) {
            return null;
        }
        try {
            return new TServerInstance(address, this.lockSessionId);
        }
        catch (Exception ex) {
            log.warn("Unable to read session from tablet server lock" + ex);
            return null;
        }
    }

    private static void checkWalCanSync(ServerContext context) {
        Set prefixes;
        VolumeChooserEnvironmentImpl chooserEnv = new VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.Scope.LOGGER, context);
        Set options = context.getBaseUris();
        try {
            prefixes = context.getVolumeManager().choosable((VolumeChooserEnvironment)chooserEnv, options);
        }
        catch (RuntimeException e) {
            log.warn("Unable to determine if WAL directories ({}) support sync or flush. Data loss may occur.", Arrays.asList(options), (Object)e);
            return;
        }
        boolean warned = false;
        for (String prefix : prefixes) {
            String logPath = prefix + "/wal";
            if (context.getVolumeManager().canSyncAndFlush(new Path(logPath))) continue;
            if (!warned) {
                UtilWaitThread.sleep((long)5000L);
                warned = true;
            }
            log.warn("WAL directory ({}) implementation does not support sync or flush. Data loss may occur.", (Object)logPath);
        }
    }

    private void config() {
        log.info("Tablet server starting on {}", (Object)this.getHostname());
        Threads.createThread((String)"Split/MajC initiator", (Runnable)new MajorCompactor(this.context)).start();
        this.clientAddress = HostAndPort.fromParts((String)this.getHostname(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabletServerStatus getStats(Map<TableId, MapCounter<ScanRunState>> scanCounts) {
        long start = System.currentTimeMillis();
        TabletServerStatus result = new TabletServerStatus();
        HashMap<String, TableInfo> tables = new HashMap<String, TableInfo>();
        this.getOnlineTablets().forEach((ke, tablet) -> {
            String tableId = ke.tableId().canonical();
            TableInfo table = (TableInfo)tables.get(tableId);
            if (table == null) {
                table = new TableInfo();
                table.minors = new Compacting();
                table.majors = new Compacting();
                tables.put(tableId, table);
            }
            long recs = tablet.getNumEntries();
            ++table.tablets;
            ++table.onlineTablets;
            table.recs += recs;
            table.queryRate += tablet.queryRate();
            table.queryByteRate += tablet.queryByteRate();
            table.ingestRate += tablet.ingestRate();
            table.ingestByteRate += tablet.ingestByteRate();
            table.scanRate += tablet.scanRate();
            long recsInMemory = tablet.getNumEntriesInMemory();
            table.recsInMemory += recsInMemory;
            if (tablet.isMinorCompactionRunning()) {
                ++table.minors.running;
            }
            if (tablet.isMinorCompactionQueued()) {
                ++table.minors.queued;
            }
            if (tablet.isMajorCompactionRunning()) {
                ++table.majors.running;
            }
            if (tablet.isMajorCompactionQueued()) {
                ++table.majors.queued;
            }
        });
        scanCounts.forEach((tableId, mapCounter) -> {
            TableInfo table = (TableInfo)tables.get(tableId.canonical());
            if (table == null) {
                table = new TableInfo();
                tables.put(tableId.canonical(), table);
            }
            if (table.scans == null) {
                table.scans = new Compacting();
            }
            table.scans.queued += mapCounter.getInt((Object)ScanRunState.QUEUED);
            table.scans.running += mapCounter.getInt((Object)ScanRunState.RUNNING);
        });
        ArrayList<KeyExtent> offlineTabletsCopy = new ArrayList<KeyExtent>();
        SortedSet<KeyExtent> sortedSet = this.unopenedTablets;
        synchronized (sortedSet) {
            SortedSet<KeyExtent> sortedSet2 = this.openingTablets;
            synchronized (sortedSet2) {
                offlineTabletsCopy.addAll(this.unopenedTablets);
                offlineTabletsCopy.addAll(this.openingTablets);
            }
        }
        for (KeyExtent extent : offlineTabletsCopy) {
            String tableId2 = extent.tableId().canonical();
            TableInfo table = (TableInfo)tables.get(tableId2);
            if (table == null) {
                table = new TableInfo();
                tables.put(tableId2, table);
            }
            ++table.tablets;
        }
        result.lastContact = RelativeTime.currentTimeMillis();
        result.tableMap = tables;
        result.osLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        result.name = this.getClientAddressString();
        result.holdTime = this.resourceManager.holdTime();
        result.lookups = seekCount.get();
        result.indexCacheHits = this.resourceManager.getIndexCache().getStats().hitCount();
        result.indexCacheRequest = this.resourceManager.getIndexCache().getStats().requestCount();
        result.dataCacheHits = this.resourceManager.getDataCache().getStats().hitCount();
        result.dataCacheRequest = this.resourceManager.getDataCache().getStats().requestCount();
        result.logSorts = this.logSorter.getLogSorts();
        result.flushs = this.flushCounter.get();
        result.syncs = this.syncCounter.get();
        result.bulkImports = new ArrayList();
        result.bulkImports.addAll(this.clientHandler.getBulkLoadStatus());
        result.bulkImports.addAll(this.bulkImportStatus.getBulkLoadStatus());
        result.version = this.getVersion();
        result.responseTime = System.currentTimeMillis() - start;
        return result;
    }

    private Durability getMincEventDurability(KeyExtent extent) {
        TableConfiguration conf = extent.isMeta() ? this.getContext().getTableConfiguration(RootTable.ID) : this.getContext().getTableConfiguration(MetadataTable.ID);
        return DurabilityImpl.fromString((String)conf.get(Property.TABLE_DURABILITY));
    }

    public void minorCompactionFinished(CommitSession tablet, long walogSeq) throws IOException {
        Durability durability = this.getMincEventDurability(tablet.getExtent());
        this.totalMinorCompactions.incrementAndGet();
        this.logger.minorCompactionFinished(tablet, walogSeq, durability);
        this.markUnusedWALs();
    }

    public void minorCompactionStarted(CommitSession tablet, long lastUpdateSequence, String newDataFileLocation) throws IOException {
        Durability durability = this.getMincEventDurability(tablet.getExtent());
        this.logger.minorCompactionStarted(tablet, lastUpdateSequence, newDataFileLocation, durability);
    }

    public void recover(VolumeManager fs, KeyExtent extent, List<LogEntry> logEntries, Set<String> tabletFiles, MutationReceiver mutationReceiver) throws IOException {
        ArrayList<Path> recoveryDirs = new ArrayList<Path>();
        ArrayList<LogEntry> sorted = new ArrayList<LogEntry>(logEntries);
        sorted.sort((e1, e2) -> (int)(e1.timestamp - e2.timestamp));
        for (LogEntry entry : sorted) {
            Path recovery = null;
            Path finished = RecoveryPath.getRecoveryPath((Path)new Path(entry.filename));
            finished = SortedLogState.getFinishedMarkerPath((Path)finished);
            log.debug("Looking for " + finished);
            if (fs.exists(finished)) {
                recovery = finished.getParent();
            }
            if (recovery == null) {
                throw new IOException("Unable to find recovery files for extent " + extent + " logEntry: " + entry);
            }
            recoveryDirs.add(recovery);
        }
        this.logger.recover(this.getContext(), extent, recoveryDirs, tabletFiles, mutationReceiver);
    }

    public int createLogId() {
        int logId = this.logIdGenerator.incrementAndGet();
        if (logId < 0) {
            throw new IllegalStateException("Log Id rolled");
        }
        return logId;
    }

    @Override
    public TableConfiguration getTableConfiguration(KeyExtent extent) {
        return this.getContext().getTableConfiguration(extent.tableId());
    }

    public DfsLogger.ServerResources getServerConfig() {
        return new DfsLogger.ServerResources(){

            @Override
            public VolumeManager getVolumeManager() {
                return TabletServer.this.getVolumeManager();
            }

            @Override
            public AccumuloConfiguration getConfiguration() {
                return TabletServer.this.getConfiguration();
            }
        };
    }

    public SortedMap<KeyExtent, Tablet> getOnlineTablets() {
        return this.onlineTablets.snapshot();
    }

    @Override
    public Tablet getOnlineTablet(KeyExtent extent) {
        return (Tablet)this.onlineTablets.snapshot().get(extent);
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public TabletServerResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public VolumeManager getVolumeManager() {
        return this.getContext().getVolumeManager();
    }

    public int getOpeningCount() {
        return this.openingTablets.size();
    }

    public int getUnopenedCount() {
        return this.unopenedTablets.size();
    }

    public long getTotalMinorCompactions() {
        return this.totalMinorCompactions.get();
    }

    public double getHoldTimeMillis() {
        return this.resourceManager.holdTime();
    }

    public SecurityOperation getSecurityOperation() {
        return this.security;
    }

    @VisibleForTesting
    static Set<DfsLogger> findOldestUnreferencedWals(List<DfsLogger> closedLogs, Consumer<Set<DfsLogger>> referencedRemover) {
        DfsLogger unref;
        DfsLogger closed;
        LinkedHashSet<DfsLogger> unreferenced = new LinkedHashSet<DfsLogger>(closedLogs);
        referencedRemover.accept(unreferenced);
        Iterator<DfsLogger> closedIter = closedLogs.iterator();
        Iterator unrefIter = unreferenced.iterator();
        HashSet<DfsLogger> eligible = new HashSet<DfsLogger>();
        while (closedIter.hasNext() && unrefIter.hasNext() && (closed = closedIter.next()).equals(unref = (DfsLogger)unrefIter.next())) {
            eligible.add(unref);
        }
        return eligible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUnusedWALs() {
        List<DfsLogger> closedCopy;
        LinkedHashSet<DfsLogger> linkedHashSet = this.closedLogs;
        synchronized (linkedHashSet) {
            closedCopy = List.copyOf(this.closedLogs);
        }
        Consumer<Set<DfsLogger>> refRemover = candidates -> {
            for (Tablet tablet : this.getOnlineTablets().values()) {
                tablet.removeInUseLogs((Set<DfsLogger>)candidates);
                if (!candidates.isEmpty()) continue;
                break;
            }
        };
        Set<DfsLogger> eligible = TabletServer.findOldestUnreferencedWals(closedCopy, refRemover);
        try {
            TServerInstance session = this.getTabletSession();
            for (DfsLogger candidate : eligible) {
                log.info("Marking " + candidate.getPath() + " as unreferenced");
                this.walMarker.walUnreferenced(session, candidate.getPath());
            }
            LinkedHashSet<DfsLogger> linkedHashSet2 = this.closedLogs;
            synchronized (linkedHashSet2) {
                this.closedLogs.removeAll(eligible);
            }
        }
        catch (WalStateManager.WalMarkerException ex) {
            log.info(ex.toString(), (Throwable)ex);
        }
    }

    public void addNewLogMarker(DfsLogger copy) throws WalStateManager.WalMarkerException {
        log.info("Writing log marker for " + copy.getPath());
        this.walMarker.addNewWalMarker(this.getTabletSession(), copy.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walogClosed(DfsLogger currentLog) throws WalStateManager.WalMarkerException {
        this.metadataTableLogs.remove(currentLog);
        if (currentLog.getWrites() > 0L) {
            int clSize;
            LinkedHashSet<DfsLogger> linkedHashSet = this.closedLogs;
            synchronized (linkedHashSet) {
                this.closedLogs.add(currentLog);
                clSize = this.closedLogs.size();
            }
            log.info("Marking " + currentLog.getPath() + " as closed. Total closed logs " + clSize);
            this.walMarker.closeWal(this.getTabletSession(), currentLog.getPath());
        } else {
            log.info("Marking " + currentLog.getPath() + " as unreferenced (skipping closed writes == 0)");
            this.walMarker.walUnreferenced(this.getTabletSession(), currentLog.getPath());
        }
    }

    public void updateBulkImportState(List<String> files, BulkImportState state) {
        this.bulkImportStatus.updateBulkImportStatus(files, state);
    }

    public void removeBulkImportState(List<String> files) {
        this.bulkImportStatus.removeBulkImportStatus(files);
    }

    public CompactionManager getCompactionManager() {
        return this.compactionManager;
    }

    public BlockCacheConfiguration getBlockCacheConfiguration(AccumuloConfiguration acuConf) {
        return BlockCacheConfiguration.forTabletServer((AccumuloConfiguration)acuConf);
    }

    private class MajorCompactor
    implements Runnable {
        public MajorCompactor(ServerContext context) {
            CompactionWatcher.startWatching((ServerContext)context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block6: while (true) {
                        List<DfsLogger> closedCopy;
                        Uninterruptibles.sleepUninterruptibly((long)TabletServer.this.getConfiguration().getTimeInMillis(Property.TSERV_MAJC_DELAY), (TimeUnit)TimeUnit.MILLISECONDS);
                        Object object = TabletServer.this.closedLogs;
                        synchronized (object) {
                            closedCopy = List.copyOf(TabletServer.this.closedLogs);
                        }
                        object = TabletServer.this.getOnlineTablets().entrySet().iterator();
                        while (true) {
                            if (!object.hasNext()) continue block6;
                            Map.Entry entry = (Map.Entry)object.next();
                            Tablet tablet = (Tablet)entry.getValue();
                            if (tablet.needsSplit(tablet.getSplitComputations())) {
                                TabletServer.this.executeSplit(tablet);
                                continue;
                            }
                            tablet.checkIfMinorCompactionNeededForLogs(closedCopy);
                        }
                        break;
                    }
                }
                catch (Exception t) {
                    log.error("Unexpected exception in {}", (Object)Thread.currentThread().getName(), (Object)t);
                    Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    continue;
                }
                break;
            }
        }
    }

    private class SplitRunner
    implements Runnable {
        private final Tablet tablet;

        public SplitRunner(Tablet tablet) {
            this.tablet = tablet;
        }

        @Override
        public void run() {
            TabletServer.this.splitTablet(this.tablet);
        }
    }
}

