/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableImport;

import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.tableImport.ImportPopulateZookeeper;
import org.apache.accumulo.manager.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.slf4j.LoggerFactory;

class ImportSetupPermissions
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    public ImportSetupPermissions(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        AuditedSecurityOperation security = env.getContext().getSecurityOperation();
        for (TablePermission permission : TablePermission.values()) {
            try {
                security.grantTablePermission(env.getContext().rpcCreds(), this.tableInfo.user, this.tableInfo.tableId, permission, this.tableInfo.namespaceId);
            }
            catch (ThriftSecurityException e) {
                LoggerFactory.getLogger(ImportSetupPermissions.class).error("{}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
        return new ImportPopulateZookeeper(this.tableInfo);
    }

    @Override
    public void undo(long tid, Manager env) throws Exception {
        env.getContext().getSecurityOperation().deleteTable(env.getContext().rpcCreds(), this.tableInfo.tableId, this.tableInfo.namespaceId);
    }
}

