/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.namespace.create;

import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.namespace.create.NamespaceInfo;
import org.apache.accumulo.manager.tableOps.namespace.create.PopulateZookeeperWithNamespace;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.slf4j.LoggerFactory;

class SetupNamespacePermissions
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceInfo namespaceInfo;

    public SetupNamespacePermissions(NamespaceInfo ti) {
        this.namespaceInfo = ti;
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        AuditedSecurityOperation security = env.getContext().getSecurityOperation();
        for (NamespacePermission permission : NamespacePermission.values()) {
            try {
                security.grantNamespacePermission(env.getContext().rpcCreds(), this.namespaceInfo.user, this.namespaceInfo.namespaceId, permission);
            }
            catch (ThriftSecurityException e) {
                LoggerFactory.getLogger(SetupNamespacePermissions.class).error("{}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
        return new PopulateZookeeperWithNamespace(this.namespaceInfo);
    }
}

