/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.compact.cancel;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.compact.cancel.FinishCancelCompaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelCompactions
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private TableId tableId;
    private NamespaceId namespaceId;
    private static final Logger log = LoggerFactory.getLogger(CancelCompactions.class);

    public CancelCompactions(NamespaceId namespaceId, TableId tableId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Manager env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, true, TableOperation.COMPACT_CANCEL) + Utils.reserveTable(env, this.tableId, tid, false, true, TableOperation.COMPACT_CANCEL);
    }

    @Override
    public Repo<Manager> call(long tid, Manager environment) throws Exception {
        CancelCompactions.mutateZooKeeper(tid, this.tableId, environment);
        return new FinishCancelCompaction(this.namespaceId, this.tableId);
    }

    @Override
    public void undo(long tid, Manager env) {
        Utils.unreserveTable(env, this.tableId, tid, false);
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
    }

    public static void mutateZooKeeper(long tid, TableId tableId, Manager environment) throws Exception {
        String zCompactID = "/accumulo/" + environment.getInstanceID() + "/tables/" + tableId + "/compact-id";
        String zCancelID = "/accumulo/" + environment.getInstanceID() + "/tables/" + tableId + "/compact-cancel-id";
        ZooReaderWriter zoo = environment.getContext().getZooReaderWriter();
        byte[] currentValue = zoo.getData(zCompactID);
        String cvs = new String(currentValue, StandardCharsets.UTF_8);
        String[] tokens = cvs.split(",");
        long flushID = Long.parseLong(tokens[0]);
        zoo.mutateExisting(zCancelID, currentValue2 -> {
            long cid = Long.parseLong(new String(currentValue2, StandardCharsets.UTF_8));
            if (cid < flushID) {
                log.debug("{} setting cancel compaction id to {} for {}", new Object[]{FateTxId.formatTid((long)tid), flushID, tableId});
                return Long.toString(flushID).getBytes(StandardCharsets.UTF_8);
            }
            log.debug("{} leaving cancel compaction id as {} for {}", new Object[]{FateTxId.formatTid((long)tid), cid, tableId});
            return Long.toString(cid).getBytes(StandardCharsets.UTF_8);
        });
    }
}

