/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.clone;

import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.clone.CloneInfo;
import org.slf4j.LoggerFactory;

class FinishCloneTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public FinishCloneTable(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager environment) {
        if (this.cloneInfo.keepOffline) {
            environment.getTableManager().transitionTableState(this.cloneInfo.tableId, TableState.OFFLINE);
        } else {
            environment.getTableManager().transitionTableState(this.cloneInfo.tableId, TableState.ONLINE);
        }
        Utils.unreserveNamespace(environment, this.cloneInfo.srcNamespaceId, tid, false);
        if (!this.cloneInfo.srcNamespaceId.equals((Object)this.cloneInfo.namespaceId)) {
            Utils.unreserveNamespace(environment, this.cloneInfo.namespaceId, tid, false);
        }
        Utils.unreserveTable(environment, this.cloneInfo.srcTableId, tid, false);
        Utils.unreserveTable(environment, this.cloneInfo.tableId, tid, true);
        environment.getEventCoordinator().event("Cloned table %s from %s", this.cloneInfo.tableName, this.cloneInfo.srcTableId);
        LoggerFactory.getLogger(FinishCloneTable.class).debug("Cloned table " + this.cloneInfo.srcTableId + " " + this.cloneInfo.tableId + " " + this.cloneInfo.tableName);
        return null;
    }

    @Override
    public void undo(long tid, Manager environment) {
    }
}

