/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps;

import com.google.gson.Gson;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import org.apache.accumulo.core.clientImpl.thrift.TInfo;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.accumulo.manager.Manager;

public class TraceRepo<T>
implements Repo<T> {
    private static final long serialVersionUID = 1L;
    TInfo tinfo;
    Repo<T> repo;

    public TraceRepo(Repo<T> repo) {
        this.repo = repo;
        this.tinfo = TraceUtil.traceInfo();
    }

    public long isReady(long tid, T environment) throws Exception {
        Span span = TraceUtil.startFateSpan(this.repo.getClass(), (String)this.repo.getName(), (TInfo)this.tinfo);
        try {
            long l;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    l = this.repo.isReady(tid, environment);
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                        throw e;
                    }
                }
                scope.close();
            }
            return l;
        }
        finally {
            span.end();
        }
    }

    public Repo<T> call(long tid, T environment) throws Exception {
        Span span = TraceUtil.startFateSpan(this.repo.getClass(), (String)this.repo.getName(), (TInfo)this.tinfo);
        try {
            TraceRepo<T> traceRepo;
            block15: {
                Repo result;
                Scope scope;
                block13: {
                    Repo<T> repo;
                    block14: {
                        scope = span.makeCurrent();
                        try {
                            result = this.repo.call(tid, environment);
                            if (result != null) break block13;
                            repo = null;
                            if (scope == null) break block14;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (scope != null) {
                                    try {
                                        scope.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                                throw e;
                            }
                        }
                        scope.close();
                    }
                    return repo;
                }
                traceRepo = new TraceRepo<T>(result);
                if (scope == null) break block15;
                scope.close();
            }
            return traceRepo;
        }
        finally {
            span.end();
        }
    }

    public void undo(long tid, T environment) throws Exception {
        Span span = TraceUtil.startFateSpan(this.repo.getClass(), (String)this.repo.getName(), (TInfo)this.tinfo);
        try (Scope scope = span.makeCurrent();){
            this.repo.undo(tid, environment);
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span.end();
        }
    }

    public String getName() {
        return this.repo.getName();
    }

    public String getReturn() {
        return this.repo.getReturn();
    }

    public static String toLogString(Repo<Manager> repo) {
        if (repo instanceof TraceRepo) {
            repo = ((TraceRepo)repo).repo;
        }
        return repo.getClass() + " " + ((Gson)LazySingletons.GSON.get()).toJson(repo, repo.getClass());
    }
}

