/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.metrics.fate;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.ZooStore;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.manager.metrics.fate.FateMetricValues;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FateMetrics
implements MetricsProducer {
    private static final Logger log = LoggerFactory.getLogger(FateMetrics.class);
    private static final long DEFAULT_MIN_REFRESH_DELAY = TimeUnit.SECONDS.toMillis(5L);
    private static final String OP_TYPE_TAG = "op.type";
    private final ServerContext context;
    private final ReadOnlyTStore<FateMetrics> zooStore;
    private final String fateRootPath;
    private final long refreshDelay;
    private AtomicLong totalCurrentOpsGauge;
    private AtomicLong totalOpsGauge;
    private AtomicLong fateErrorsGauge;
    private AtomicLong newTxGauge;
    private AtomicLong submittedTxGauge;
    private AtomicLong inProgressTxGauge;
    private AtomicLong failedInProgressTxGauge;
    private AtomicLong failedTxGauge;
    private AtomicLong successfulTxGauge;
    private AtomicLong unknownTxGauge;

    public FateMetrics(ServerContext context, long minimumRefreshDelay) {
        this.context = context;
        this.fateRootPath = context.getZooKeeperRoot() + "/fate";
        this.refreshDelay = Math.max(DEFAULT_MIN_REFRESH_DELAY, minimumRefreshDelay);
        try {
            this.zooStore = new ZooStore(this.fateRootPath, context.getZooReaderWriter());
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("FATE Metrics - Failed to create zoo store - metrics unavailable", ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("FATE Metrics - Interrupt received while initializing zoo store");
        }
    }

    private void update() {
        FateMetricValues metricValues = FateMetricValues.getFromZooKeeper(this.context, this.fateRootPath, this.zooStore);
        this.totalCurrentOpsGauge.set(metricValues.getCurrentFateOps());
        this.totalOpsGauge.set(metricValues.getZkFateChildOpsTotal());
        this.fateErrorsGauge.set(metricValues.getZkConnectionErrors());
        block9: for (Map.Entry<String, Long> vals : metricValues.getTxStateCounters().entrySet()) {
            switch (ReadOnlyTStore.TStatus.valueOf((String)vals.getKey())) {
                case NEW: {
                    this.newTxGauge.set(vals.getValue());
                    continue block9;
                }
                case SUBMITTED: {
                    this.submittedTxGauge.set(vals.getValue());
                    continue block9;
                }
                case IN_PROGRESS: {
                    this.inProgressTxGauge.set(vals.getValue());
                    continue block9;
                }
                case FAILED_IN_PROGRESS: {
                    this.failedInProgressTxGauge.set(vals.getValue());
                    continue block9;
                }
                case FAILED: {
                    this.failedTxGauge.set(vals.getValue());
                    continue block9;
                }
                case SUCCESSFUL: {
                    this.successfulTxGauge.set(vals.getValue());
                    continue block9;
                }
                case UNKNOWN: {
                    this.unknownTxGauge.set(vals.getValue());
                    continue block9;
                }
            }
            log.warn("Unhandled status type: {}", (Object)vals.getKey());
        }
        metricValues.getOpTypeCounters().forEach((name, count) -> Metrics.gauge((String)"accumulo.fate.ops.in.progress.by.type", (Iterable)Tags.of((String)OP_TYPE_TAG, (String)name), (Number)count));
    }

    public void registerMetrics(MeterRegistry registry) {
        this.totalCurrentOpsGauge = (AtomicLong)registry.gauge("accumulo.fate.ops.in.progress", (Iterable)MetricsUtil.getCommonTags(), (Number)new AtomicLong(0L));
        this.totalOpsGauge = (AtomicLong)registry.gauge("accumulo.fate.ops.activity", (Iterable)MetricsUtil.getCommonTags(), (Number)new AtomicLong(0L));
        this.fateErrorsGauge = (AtomicLong)registry.gauge("accumulo.fate.errors", (Iterable)Tags.concat((Iterable)MetricsUtil.getCommonTags(), (String[])new String[]{"type", "zk.connection"}), (Number)new AtomicLong(0L));
        this.newTxGauge = (AtomicLong)registry.gauge("accumulo.fate.tx", (Iterable)Tags.concat((Iterable)MetricsUtil.getCommonTags(), (String[])new String[]{"state", ReadOnlyTStore.TStatus.NEW.name().toLowerCase()}), (Number)new AtomicLong(0L));
        this.submittedTxGauge = (AtomicLong)registry.gauge("accumulo.fate.tx", (Iterable)Tags.concat((Iterable)MetricsUtil.getCommonTags(), (String[])new String[]{"state", ReadOnlyTStore.TStatus.SUBMITTED.name().toLowerCase()}), (Number)new AtomicLong(0L));
        this.inProgressTxGauge = (AtomicLong)registry.gauge("accumulo.fate.tx", (Iterable)Tags.concat((Iterable)MetricsUtil.getCommonTags(), (String[])new String[]{"state", ReadOnlyTStore.TStatus.IN_PROGRESS.name().toLowerCase()}), (Number)new AtomicLong(0L));
        this.failedInProgressTxGauge = (AtomicLong)registry.gauge("accumulo.fate.tx", (Iterable)Tags.concat((Iterable)MetricsUtil.getCommonTags(), (String[])new String[]{"state", ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS.name().toLowerCase()}), (Number)new AtomicLong(0L));
        this.failedTxGauge = (AtomicLong)registry.gauge("accumulo.fate.tx", (Iterable)Tags.concat((Iterable)MetricsUtil.getCommonTags(), (String[])new String[]{"state", ReadOnlyTStore.TStatus.FAILED.name().toLowerCase()}), (Number)new AtomicLong(0L));
        this.successfulTxGauge = (AtomicLong)registry.gauge("accumulo.fate.tx", (Iterable)Tags.concat((Iterable)MetricsUtil.getCommonTags(), (String[])new String[]{"state", ReadOnlyTStore.TStatus.SUCCESSFUL.name().toLowerCase()}), (Number)new AtomicLong(0L));
        this.unknownTxGauge = (AtomicLong)registry.gauge("accumulo.fate.tx", (Iterable)Tags.concat((Iterable)MetricsUtil.getCommonTags(), (String[])new String[]{"state", ReadOnlyTStore.TStatus.UNKNOWN.name().toLowerCase()}), (Number)new AtomicLong(0L));
        this.update();
        ScheduledThreadPoolExecutor scheduler = ThreadPools.getServerThreadPools().createScheduledExecutorService(1, "fateMetricsPoller", false);
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(() -> {
            try {
                this.update();
            }
            catch (Exception ex) {
                log.info("Failed to update fate metrics due to exception", (Throwable)ex);
            }
        }, this.refreshDelay, this.refreshDelay, TimeUnit.MILLISECONDS);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }
}

