/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.logging;

import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.monitor.rest.logs.SingleLogEvent;
import org.apache.accumulo.server.ServerContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="AccumuloMonitor", category="Core", elementType="appender", printObject=true)
public class AccumuloMonitorAppender
extends AbstractAppender {
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final Supplier<Optional<URI>> monitorLocator;
    private ServerContext context;
    private String path;
    private Pair<Long, Optional<URI>> lastResult = new Pair((Object)0L, Optional.empty());

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private AccumuloMonitorAppender(String name, Filter filter, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, null, ignoreExceptions, properties);
        ZooCache.ZcStat stat = new ZooCache.ZcStat();
        this.monitorLocator = () -> {
            if (this.context == null) {
                this.context = new ServerContext(SiteConfiguration.auto());
                this.path = this.context.getZooKeeperRoot() + "/monitor/http_addr";
            }
            byte[] loc = this.context.getZooCache().get(this.path, stat);
            Pair last = this.lastResult;
            if (stat.getMzxid() != ((Long)last.getFirst()).longValue()) {
                this.lastResult = last = new Pair((Object)stat.getMzxid(), Optional.ofNullable(loc).map(bytes -> URI.create(new String((byte[])bytes, StandardCharsets.UTF_8) + "rest/logs/append")));
            }
            return (Optional)last.getSecond();
        };
    }

    public void append(LogEvent event) {
        this.monitorLocator.get().ifPresent(uri -> {
            try {
                SingleLogEvent pojo = new SingleLogEvent();
                pojo.timestamp = event.getTimeMillis();
                pojo.application = System.getProperty("accumulo.application", "unknown");
                pojo.logger = event.getLoggerName();
                pojo.level = event.getLevel().name();
                pojo.message = event.getMessage().getFormattedMessage();
                pojo.stacktrace = AccumuloMonitorAppender.throwableToStacktrace(event.getThrown());
                String jsonEvent = ((Gson)LazySingletons.GSON.get()).toJson((Object)pojo);
                HttpRequest req = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.ofString(jsonEvent, StandardCharsets.UTF_8)).setHeader("Content-Type", "application/json").build();
                CompletableFuture<HttpResponse<Void>> completableFuture = this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.discarding());
            }
            catch (Exception e) {
                this.error("Unable to send HTTP in appender [" + this.getName() + "]", event, e);
            }
        });
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="throwable is intended to be printed to output stream, to send to monitor")
    private static String throwableToStacktrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public String toString() {
        return "AccumuloMonitorAppender{name=" + this.getName() + ", state=" + this.getState() + "}";
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<AccumuloMonitorAppender> {
        public AccumuloMonitorAppender build() {
            return new AccumuloMonitorAppender(this.getName(), this.getFilter(), this.isIgnoreExceptions(), this.getPropertyArray());
        }
    }
}

