/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.SummaryRetriever;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.accumulo.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class SummariesCommand
extends TableOperation {
    private Text startRow;
    private Text endRow;
    private boolean paginate;
    private String selectionRegex = ".*";
    private Option disablePaginationOpt;
    private Option summarySelectionOpt;

    @Override
    public String description() {
        return "retrieves summary statistics";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException {
        AccumuloClient client = shellState.getAccumuloClient();
        SummaryRetriever retriever = client.tableOperations().summaries(tableName).withMatchingConfiguration(this.selectionRegex);
        if (this.startRow != null) {
            retriever.startRow(this.startRow);
        }
        if (this.endRow != null) {
            retriever.endRow(this.endRow);
        }
        List summaries = retriever.retrieve();
        ArrayList<String> lines = new ArrayList<String>();
        boolean addEmpty = false;
        for (Summary summary : summaries) {
            if (addEmpty) {
                lines.add("");
            }
            addEmpty = true;
            lines.add(String.format(" Summarizer         : %s", summary.getSummarizerConfiguration()));
            lines.add(String.format(" File Statistics    : %s", summary.getFileStatistics()));
            lines.add(" Summary Statistics : ");
            Map stats = summary.getStatistics();
            ArrayList keys = new ArrayList(stats.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                lines.add(String.format("    %-60s = %,d", key, stats.get(key)));
            }
        }
        shellState.printLines(lines.iterator(), this.paginate);
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        this.startRow = OptUtil.getStartRow(cl);
        this.endRow = OptUtil.getEndRow(cl);
        this.paginate = !cl.hasOption(this.disablePaginationOpt.getOpt());
        this.selectionRegex = cl.hasOption(this.summarySelectionOpt.getOpt()) ? cl.getOptionValue(this.summarySelectionOpt.getOpt()) : ".*";
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        this.summarySelectionOpt = new Option("sr", "select-regex", true, "regex to select summaries. Matches against class name and options used to generate summaries.");
        opts.addOption(this.disablePaginationOpt);
        opts.addOption(this.summarySelectionOpt);
        opts.addOption(OptUtil.startRowOpt());
        opts.addOption(OptUtil.endRowOpt());
        return opts;
    }
}

