/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.threads;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AccumuloUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AccumuloUncaughtExceptionHandler.class);

    AccumuloUncaughtExceptionHandler() {
    }

    private static boolean isError(Throwable t, int depth) {
        if (depth > 32) {
            return true;
        }
        while (t != null) {
            if (t instanceof Error) {
                return true;
            }
            for (Throwable suppressed : t.getSuppressed()) {
                if (!AccumuloUncaughtExceptionHandler.isError(suppressed, depth + 1)) continue;
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    static boolean isError(Throwable t) {
        return AccumuloUncaughtExceptionHandler.isError(t, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (AccumuloUncaughtExceptionHandler.isError(e)) {
            try {
                e.printStackTrace();
                System.err.println("Error thrown in thread: " + t + ", halting VM.");
            }
            catch (Throwable throwable) {
            }
            finally {
                Runtime.getRuntime().halt(-1);
            }
        } else {
            LOG.error("Caught an Exception in {}. Thread is dead.", (Object)t, (Object)e);
        }
    }
}

