/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.ratelimit;

import org.apache.accumulo.core.util.ratelimit.RateLimiter;

public class GuavaRateLimiter
implements RateLimiter {
    private final com.google.common.util.concurrent.RateLimiter rateLimiter;
    private long currentRate;

    public GuavaRateLimiter(long initialRate) {
        this.currentRate = initialRate;
        this.rateLimiter = com.google.common.util.concurrent.RateLimiter.create((double)(initialRate > 0L ? (double)initialRate : 9.223372036854776E18));
    }

    @Override
    public long getRate() {
        return this.currentRate;
    }

    public void setRate(long newRate) {
        this.rateLimiter.setRate(newRate > 0L ? (double)newRate : 9.223372036854776E18);
        this.currentRate = newRate;
    }

    @Override
    public void acquire(long numPermits) {
        if (this.currentRate > 0L) {
            while (numPermits > Integer.MAX_VALUE) {
                this.rateLimiter.acquire(Integer.MAX_VALUE);
                numPermits -= Integer.MAX_VALUE;
            }
            if (numPermits > 0L) {
                this.rateLimiter.acquire((int)numPermits);
            }
        }
    }
}

