/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.spi.scan.ScanServerInfo;
import org.apache.accumulo.core.spi.scan.ScanServerSelections;
import org.apache.accumulo.core.spi.scan.ScanServerSelector;
import org.apache.accumulo.core.util.LazySingletons;

public class ConfigurableScanServerSelector
implements ScanServerSelector {
    public static final String PROFILES_DEFAULT = "[{'isDefault':true,'maxBusyTimeout':'5m','busyTimeoutMultiplier':8, 'scanTypeActivations':[], 'attemptPlans':[{'servers':'3', 'busyTimeout':'33ms', 'salt':'one'},{'servers':'13', 'busyTimeout':'33ms', 'salt':'two'},{'servers':'100%', 'busyTimeout':'33ms'}]}]";
    private Supplier<Map<String, List<String>>> orderedScanServersSupplier;
    private Map<String, Profile> profiles;
    private Profile defaultProfile;
    private static final Set<String> OPT_NAMES = Set.of("profiles");

    private void parseProfiles(Map<String, String> options) {
        Type listType = new TypeToken<ArrayList<Profile>>(){}.getType();
        List profList = (List)LazySingletons.GSON.get().fromJson(options.getOrDefault("profiles", PROFILES_DEFAULT), listType);
        this.profiles = new HashMap<String, Profile>();
        this.defaultProfile = null;
        for (Profile prof : profList) {
            if (prof.scanTypeActivations != null) {
                for (String scanType : prof.scanTypeActivations) {
                    if (this.profiles.put(scanType, prof) == null) continue;
                    throw new IllegalArgumentException("Scan type activation seen in multiple profiles : " + scanType);
                }
            }
            if (!prof.isDefault) continue;
            if (this.defaultProfile != null) {
                throw new IllegalArgumentException("Multiple default profiles seen");
            }
            this.defaultProfile = prof;
        }
        if (this.defaultProfile == null) {
            throw new IllegalArgumentException("No default profile specified");
        }
    }

    @Override
    public void init(ScanServerSelector.InitParameters params) {
        this.orderedScanServersSupplier = Suppliers.memoizeWithExpiration(() -> {
            Collection<ScanServerInfo> scanServers = params.getScanServers().get();
            HashMap groupedServers = new HashMap();
            scanServers.forEach(sserver -> groupedServers.computeIfAbsent(sserver.getGroup(), k -> new ArrayList()).add(sserver.getAddress()));
            groupedServers.values().forEach(ssAddrs -> Collections.sort(ssAddrs));
            return groupedServers;
        }, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        Map<String, String> opts = params.getOptions();
        Sets.SetView diff = Sets.difference(opts.keySet(), OPT_NAMES);
        Preconditions.checkArgument((boolean)diff.isEmpty(), (String)"Unknown options %s", (Object)diff);
        this.parseProfiles(params.getOptions());
    }

    @Override
    public ScanServerSelections selectServers(ScanServerSelector.SelectorParameters params) {
        String scanType = params.getHints().get("scan_type");
        Profile profile = null;
        profile = scanType != null ? this.profiles.getOrDefault(scanType, this.defaultProfile) : this.defaultProfile;
        List orderedScanServers = this.orderedScanServersSupplier.get().getOrDefault(profile.group, List.of());
        if (orderedScanServers.isEmpty()) {
            return new ScanServerSelections(){

                @Override
                public String getScanServer(TabletId tabletId) {
                    return null;
                }

                @Override
                public Duration getDelay() {
                    return Duration.ZERO;
                }

                @Override
                public Duration getBusyTimeout() {
                    return Duration.ZERO;
                }
            };
        }
        final HashMap<TabletId, String> serversToUse = new HashMap<TabletId, String>();
        int attempts = params.getTablets().stream().mapToInt(tablet -> params.getAttempts((TabletId)tablet).size()).max().orElse(0);
        int numServers = profile.getNumServers(attempts, orderedScanServers.size());
        for (TabletId tablet2 : params.getTablets()) {
            String serverToUse = null;
            HashCode hashCode = this.hashTablet(tablet2, profile.getSalt(attempts));
            int serverIndex = (Math.abs(hashCode.asInt()) + LazySingletons.RANDOM.get().nextInt(numServers)) % orderedScanServers.size();
            serverToUse = (String)orderedScanServers.get(serverIndex);
            serversToUse.put(tablet2, serverToUse);
        }
        final Duration busyTO = Duration.ofMillis(profile.getBusyTimeout(attempts));
        return new ScanServerSelections(){

            @Override
            public String getScanServer(TabletId tabletId) {
                return (String)serversToUse.get(tabletId);
            }

            @Override
            public Duration getDelay() {
                return Duration.ZERO;
            }

            @Override
            public Duration getBusyTimeout() {
                return busyTO;
            }
        };
    }

    private HashCode hashTablet(TabletId tablet, String salt) {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        if (tablet.getEndRow() != null) {
            hasher.putBytes(tablet.getEndRow().getBytes(), 0, tablet.getEndRow().getLength());
        } else {
            hasher.putByte((byte)5);
        }
        if (tablet.getPrevEndRow() != null) {
            hasher.putBytes(tablet.getPrevEndRow().getBytes(), 0, tablet.getPrevEndRow().getLength());
        } else {
            hasher.putByte((byte)7);
        }
        hasher.putString((CharSequence)tablet.getTable().canonical(), StandardCharsets.UTF_8);
        if (salt != null && !salt.isEmpty()) {
            hasher.putString((CharSequence)salt, StandardCharsets.UTF_8);
        }
        return hasher.hash();
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="Object deserialized by GSON")
    private static class Profile {
        public List<AttemptPlan> attemptPlans;
        List<String> scanTypeActivations;
        boolean isDefault = false;
        int busyTimeoutMultiplier;
        String maxBusyTimeout;
        String group = "default";
        transient boolean parsed = false;
        transient long parsedMaxBusyTimeout;

        private Profile() {
        }

        int getNumServers(int attempt, int totalServers) {
            int index = Math.min(attempt, this.attemptPlans.size() - 1);
            return this.attemptPlans.get(index).getNumServers(totalServers);
        }

        void parse() {
            if (this.parsed) {
                return;
            }
            this.parsedMaxBusyTimeout = ConfigurationTypeHelper.getTimeInMillis(this.maxBusyTimeout);
            this.parsed = true;
        }

        long getBusyTimeout(int attempt) {
            int index = Math.min(attempt, this.attemptPlans.size() - 1);
            long busyTimeout = this.attemptPlans.get(index).getBusyTimeout();
            if (attempt >= this.attemptPlans.size()) {
                this.parse();
                busyTimeout = (long)((double)busyTimeout * Math.pow(this.busyTimeoutMultiplier, attempt - this.attemptPlans.size() + 1));
                busyTimeout = Math.min(busyTimeout, this.parsedMaxBusyTimeout);
            }
            return busyTimeout;
        }

        public String getSalt(int attempts) {
            int index = Math.min(attempts, this.attemptPlans.size() - 1);
            return this.attemptPlans.get((int)index).salt;
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="Object deserialized by GSON")
    private static class AttemptPlan {
        String servers;
        String busyTimeout;
        String salt = "";
        transient double serversRatio;
        transient int parsedServers;
        transient boolean isServersPercent;
        transient boolean parsed = false;
        transient long parsedBusyTimeout;

        private AttemptPlan() {
        }

        void parse() {
            if (this.parsed) {
                return;
            }
            if (this.servers.endsWith("%")) {
                this.serversRatio = Double.parseDouble(this.servers.substring(0, this.servers.length() - 1)) / 100.0;
                if (this.serversRatio < 0.0 || this.serversRatio > 1.0) {
                    throw new IllegalArgumentException("Bad servers percentage : " + this.servers);
                }
                this.isServersPercent = true;
            } else {
                this.parsedServers = Integer.parseInt(this.servers);
                if (this.parsedServers <= 0) {
                    throw new IllegalArgumentException("Server must be positive : " + this.servers);
                }
                this.isServersPercent = false;
            }
            this.parsedBusyTimeout = ConfigurationTypeHelper.getTimeInMillis(this.busyTimeout);
            this.parsed = true;
        }

        int getNumServers(int totalServers) {
            this.parse();
            if (this.isServersPercent) {
                return Math.max(1, (int)Math.round(this.serversRatio * (double)totalServers));
            }
            return Math.min(totalServers, this.parsedServers);
        }

        long getBusyTimeout() {
            this.parse();
            return this.parsedBusyTimeout;
        }
    }
}

