/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.manager.balancer.TabletServerIdImpl;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TableStatistics;
import org.apache.accumulo.core.spi.balancer.data.TabletMigration;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.apache.accumulo.core.spi.balancer.data.TabletStatistics;
import org.apache.accumulo.core.spi.balancer.util.ThrottledBalancerProblemReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoadBalancer
implements TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(SimpleLoadBalancer.class);
    protected BalancerEnvironment environment;
    Iterator<TabletServerId> assignments;
    TableId tableToBalance = null;
    private final ThrottledBalancerProblemReporter problemReporter = new ThrottledBalancerProblemReporter(this.getClass());
    private final ThrottledBalancerProblemReporter.Problem noTserversProblem = this.problemReporter.createNoTabletServersProblem();
    private final ThrottledBalancerProblemReporter.OutstandingMigrationsProblem outstandingMigrationsProblem = this.problemReporter.createOutstandingMigrationsProblem();

    public SimpleLoadBalancer() {
    }

    public SimpleLoadBalancer(TableId table) {
        this.tableToBalance = table;
    }

    @Override
    public void init(BalancerEnvironment balancerEnvironment) {
        this.environment = balancerEnvironment;
    }

    List<TabletServerId> randomize(Set<TabletServerId> locations) {
        ArrayList<TabletServerId> result = new ArrayList<TabletServerId>(locations);
        Collections.shuffle(result);
        return result;
    }

    public TabletServerId getAssignment(SortedMap<TabletServerId, TServerStatus> locations, TabletServerId last) {
        TabletServerId result;
        if (locations.isEmpty()) {
            return null;
        }
        if (last != null) {
            TabletServerId current;
            String fakeSessionID = " ";
            TabletServerIdImpl simple = new TabletServerIdImpl(last.getHost(), last.getPort(), fakeSessionID);
            Iterator<TabletServerId> find = locations.tailMap(simple).keySet().iterator();
            if (find.hasNext() && (current = find.next()).getHost().equals(last.getHost())) {
                return current;
            }
        }
        if (this.assignments == null || !this.assignments.hasNext()) {
            this.assignments = this.randomize(locations.keySet()).iterator();
        }
        if (!locations.containsKey(result = this.assignments.next())) {
            this.assignments = null;
            return this.randomize(locations.keySet()).iterator().next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMigrations(Map<TabletServerId, TServerStatus> current, List<TabletMigration> result) {
        boolean moreBalancingNeeded = false;
        try {
            if (current.size() < 2) {
                boolean bl = false;
                return bl;
            }
            HashMap<TableId, Map<TabletId, TabletStatistics>> donerTabletStats = new HashMap<TableId, Map<TabletId, TabletStatistics>>();
            int total = 0;
            ArrayList<ServerCounts> totals = new ArrayList<ServerCounts>();
            for (Map.Entry<TabletServerId, TServerStatus> entry : current.entrySet()) {
                int serverTotal = 0;
                if (entry.getValue() != null && entry.getValue().getTableMap() != null) {
                    for (Map.Entry<String, TableStatistics> e : entry.getValue().getTableMap().entrySet()) {
                        if (this.tableToBalance != null && !this.tableToBalance.canonical().equals(e.getKey())) continue;
                        serverTotal += e.getValue().getOnlineTabletCount();
                    }
                }
                totals.add(new ServerCounts(serverTotal, entry.getKey(), entry.getValue()));
                total += serverTotal;
            }
            totals.sort(Collections.reverseOrder());
            int even = total / totals.size();
            int numServersOverEven = total % totals.size();
            int end = totals.size() - 1;
            int movedAlready = 0;
            int tooManyIndex = 0;
            while (tooManyIndex < end) {
                ServerCounts tooMany = (ServerCounts)totals.get(tooManyIndex);
                int goal = even;
                if (tooManyIndex < numServersOverEven) {
                    ++goal;
                }
                int needToUnload = tooMany.count - goal;
                ServerCounts tooLittle = (ServerCounts)totals.get(end);
                int needToLoad = goal - tooLittle.count - movedAlready;
                if (needToUnload < 1 && needToLoad < 1) {
                    break;
                }
                if (needToUnload >= needToLoad) {
                    result.addAll(this.move(tooMany, tooLittle, needToLoad, donerTabletStats));
                    --end;
                    movedAlready = 0;
                } else {
                    result.addAll(this.move(tooMany, tooLittle, needToUnload, donerTabletStats));
                    movedAlready += needToUnload;
                }
                if (needToUnload > needToLoad) {
                    moreBalancingNeeded = true;
                    continue;
                }
                ++tooManyIndex;
                donerTabletStats.clear();
            }
        }
        finally {
            log.trace("balance ended with {} migrations", (Object)result.size());
        }
        return moreBalancingNeeded;
    }

    List<TabletMigration> move(ServerCounts tooMuch, ServerCounts tooLittle, int count, Map<TableId, Map<TabletId, TabletStatistics>> donerTabletStats) {
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<TabletMigration> result = new ArrayList<TabletMigration>();
        Map<TableId, Integer> tooMuchMap = SimpleLoadBalancer.tabletCountsPerTable(tooMuch.status);
        Map<TableId, Integer> tooLittleMap = SimpleLoadBalancer.tabletCountsPerTable(tooLittle.status);
        for (int i = 0; i < count; ++i) {
            TableId table = this.getTableToMigrate(tooMuch, tooMuchMap, tooLittleMap);
            Map<TabletId, TabletStatistics> onlineTabletsForTable = donerTabletStats.get(table);
            try {
                if (onlineTabletsForTable == null) {
                    onlineTabletsForTable = new HashMap<TabletId, TabletStatistics>();
                    List<TabletStatistics> stats = this.getOnlineTabletsForTable(tooMuch.server, table);
                    if (stats == null) {
                        log.warn("Unable to find tablets to move");
                        return result;
                    }
                    for (TabletStatistics stat : stats) {
                        onlineTabletsForTable.put(stat.getTabletId(), stat);
                    }
                    donerTabletStats.put(table, onlineTabletsForTable);
                }
            }
            catch (Exception ex) {
                log.error("Unable to select a tablet to move", (Throwable)ex);
                return result;
            }
            TabletId tabletId = SimpleLoadBalancer.selectTablet(onlineTabletsForTable);
            onlineTabletsForTable.remove(tabletId);
            if (tabletId == null) {
                return result;
            }
            tooMuchMap.put(table, tooMuchMap.get(table) - 1);
            Integer tooLittleCount = tooLittleMap.getOrDefault(table, 0);
            tooLittleMap.put(table, tooLittleCount + 1);
            --tooMuch.count;
            ++tooLittle.count;
            result.add(new TabletMigration(tabletId, tooMuch.server, tooLittle.server));
        }
        return result;
    }

    private TableId getTableToMigrate(ServerCounts tooMuch, Map<TableId, Integer> tooMuchMap, Map<TableId, Integer> tooLittleMap) {
        if (this.tableToBalance != null) {
            return this.tableToBalance;
        }
        Map.Entry biggestEntry = tooMuchMap.entrySet().stream().map(entry -> {
            TableId tableID = (TableId)entry.getKey();
            int diff = (Integer)entry.getValue() - tooLittleMap.getOrDefault(tableID, 0);
            return new AbstractMap.SimpleEntry<TableId, Integer>(tableID, diff);
        }).max(Map.Entry.comparingByValue()).orElseGet(() -> new AbstractMap.SimpleEntry<Object, Integer>(null, 0));
        if ((Integer)biggestEntry.getValue() < 2) {
            return SimpleLoadBalancer.busiest(tooMuch.status.getTableMap());
        }
        return (TableId)biggestEntry.getKey();
    }

    protected List<TabletStatistics> getOnlineTabletsForTable(TabletServerId tabletServerId, TableId tableId) throws AccumuloSecurityException, AccumuloException {
        return this.environment.listOnlineTabletsForTable(tabletServerId, tableId);
    }

    static Map<TableId, Integer> tabletCountsPerTable(TServerStatus status) {
        HashMap<TableId, Integer> result = new HashMap<TableId, Integer>();
        if (status != null && status.getTableMap() != null) {
            Map<String, TableStatistics> tableMap = status.getTableMap();
            for (Map.Entry<String, TableStatistics> entry : tableMap.entrySet()) {
                result.put(TableId.of(entry.getKey()), entry.getValue().getOnlineTabletCount());
            }
        }
        return result;
    }

    static TabletId selectTablet(Map<TabletId, TabletStatistics> extents) {
        if (extents.isEmpty()) {
            return null;
        }
        TabletId mostRecentlySplit = null;
        long splitTime = 0L;
        for (Map.Entry<TabletId, TabletStatistics> entry : extents.entrySet()) {
            if (entry.getValue().getSplitCreationTime() < splitTime) continue;
            splitTime = entry.getValue().getSplitCreationTime();
            mostRecentlySplit = entry.getKey();
        }
        return mostRecentlySplit;
    }

    private static TableId busiest(Map<String, TableStatistics> tables) {
        TableId result = null;
        double busiest = Double.NEGATIVE_INFINITY;
        for (Map.Entry<String, TableStatistics> entry : tables.entrySet()) {
            TableStatistics info = entry.getValue();
            double busy = info.getIngestRate() + info.getQueryRate();
            if (!(busy > busiest)) continue;
            busiest = busy;
            result = TableId.of(entry.getKey());
        }
        return result;
    }

    @Override
    public void getAssignments(TabletBalancer.AssignmentParameters params) {
        params.unassignedTablets().forEach((tabletId, tserverId) -> params.addAssignment((TabletId)tabletId, this.getAssignment(params.currentStatus(), (TabletServerId)tserverId)));
    }

    @Override
    public long balance(TabletBalancer.BalanceParameters params) {
        if (params.currentStatus().isEmpty()) {
            this.problemReporter.reportProblem(this.noTserversProblem);
        } else if (params.currentMigrations().isEmpty()) {
            this.problemReporter.clearProblemReportTimes();
            if (this.getMigrations(params.currentStatus(), params.migrationsOut())) {
                return TimeUnit.SECONDS.toMillis(1L);
            }
        } else {
            this.outstandingMigrationsProblem.setMigrations(params.currentMigrations());
            this.problemReporter.reportProblem(this.outstandingMigrationsProblem);
        }
        return 5000L;
    }

    static class ServerCounts
    implements Comparable<ServerCounts> {
        public final TabletServerId server;
        public int count;
        public final TServerStatus status;

        ServerCounts(int count, TabletServerId server, TServerStatus status) {
            this.count = count;
            this.server = server;
            this.status = status;
        }

        public int hashCode() {
            return Objects.hashCode(this.server) + this.count;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ServerCounts && this.compareTo((ServerCounts)obj) == 0;
        }

        @Override
        public int compareTo(ServerCounts obj) {
            int result = this.count - obj.count;
            if (result == 0) {
                return this.server.compareTo(obj.server);
            }
            return result;
        }
    }
}

