/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public enum SystemPermission {
    GRANT(0),
    CREATE_TABLE(1),
    DROP_TABLE(2),
    ALTER_TABLE(3),
    CREATE_USER(4),
    DROP_USER(5),
    ALTER_USER(6),
    SYSTEM(7),
    CREATE_NAMESPACE(8),
    DROP_NAMESPACE(9),
    ALTER_NAMESPACE(10),
    OBTAIN_DELEGATION_TOKEN(11);

    private byte permID;
    private static HashMap<Byte, SystemPermission> mapping;

    private SystemPermission(byte id) {
        this.permID = id;
    }

    public byte getId() {
        return this.permID;
    }

    public static List<String> printableValues() {
        SystemPermission[] a = SystemPermission.values();
        ArrayList<String> list = new ArrayList<String>(a.length);
        for (SystemPermission p : a) {
            list.add("System." + p);
        }
        return list;
    }

    public static SystemPermission getPermissionById(byte id) {
        if (mapping.containsKey(id)) {
            return mapping.get(id);
        }
        throw new IndexOutOfBoundsException("No such permission");
    }

    static {
        mapping = new HashMap(SystemPermission.values().length);
        for (SystemPermission perm : SystemPermission.values()) {
            mapping.put(perm.permID, perm);
        }
    }
}

