/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc.clients;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ThriftTransportKey;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.lock.ServiceLockData;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.util.Pair;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;

public interface TServerClient<C extends TServiceClient> {
    public Pair<String, C> getTabletServerConnection(ClientContext var1, boolean var2) throws TTransportException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Pair<String, C> getTabletServerConnection(Logger LOG, ThriftClientTypes<C> type, ClientContext context, boolean preferCachedConnections, AtomicBoolean warned) throws TTransportException {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        long rpcTimeout = context.getClientTimeoutInMillis();
        ArrayList<ThriftTransportKey> servers = new ArrayList<ThriftTransportKey>();
        ZooCache zc = context.getZooCache();
        for (String tserver : zc.getChildren(context.getZooKeeperRoot() + "/tservers")) {
            HostAndPort address;
            ServiceLock.ServiceLockPath zLocPath = ServiceLock.path(context.getZooKeeperRoot() + "/tservers/" + tserver);
            Optional<ServiceLockData> sld = zc.getLockData(zLocPath);
            if (!sld.isPresent() || (address = sld.orElseThrow().getAddress(ServiceLockData.ThriftService.TSERV)) == null) continue;
            servers.add(new ThriftTransportKey(address, rpcTimeout, context));
        }
        boolean opened = false;
        try {
            Pair<String, TTransport> pair = context.getTransportPool().getAnyTransport(servers, preferCachedConnections);
            C client = ThriftUtil.createClient(type, pair.getSecond());
            opened = true;
            warned.set(false);
            Pair<String, C> pair2 = new Pair<String, C>(pair.getFirst(), client);
            return pair2;
        }
        finally {
            if (!opened && warned.compareAndSet(false, true)) {
                if (servers.isEmpty()) {
                    LOG.warn("There are no tablet servers: check that zookeeper and accumulo are running.");
                } else {
                    LOG.warn("Failed to find an available server in the list of servers: {}", servers);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    default public <R> R execute(Logger LOG, ClientContext context, ThriftClientTypes.Exec<R, C> exec) throws AccumuloException, AccumuloSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    default public void executeVoid(Logger LOG, ClientContext context, ThriftClientTypes.ExecVoid<C> exec) throws AccumuloException, AccumuloSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

