/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metrics;

import com.google.common.net.HostAndPort;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metrics.MeterRegistryFactory;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUtil.class);
    private static JvmGcMetrics gc;
    private static List<Tag> commonTags;

    public static void initializeMetrics(AccumuloConfiguration conf, String appName, HostAndPort address) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        MetricsUtil.initializeMetrics(conf.getBoolean(Property.GENERAL_MICROMETER_ENABLED), conf.getBoolean(Property.GENERAL_MICROMETER_JVM_METRICS_ENABLED), conf.get(Property.GENERAL_MICROMETER_FACTORY), appName, address);
    }

    private static void initializeMetrics(boolean enabled, boolean jvmMetricsEnabled, String factoryClass, String appName, HostAndPort address) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LOG.info("initializing metrics, enabled:{}, class:{}", (Object)enabled, (Object)factoryClass);
        if (enabled && factoryClass != null && !factoryClass.isEmpty()) {
            Object processName = appName;
            String serviceInstance = System.getProperty("accumulo.metrics.service.instance", "");
            if (!serviceInstance.isBlank()) {
                processName = (String)processName + serviceInstance;
            }
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(Tag.of((String)"process.name", (String)processName));
            if (address != null) {
                if (!address.getHost().isEmpty()) {
                    tags.add(Tag.of((String)"host", (String)address.getHost()));
                }
                if (address.getPort() > 0) {
                    tags.add(Tag.of((String)"port", (String)Integer.toString(address.getPort())));
                }
            }
            commonTags = Collections.unmodifiableList(tags);
            Class<MeterRegistryFactory> clazz = ClassLoaderUtil.loadClass(factoryClass, MeterRegistryFactory.class);
            MeterRegistryFactory factory = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            MeterRegistry registry = factory.create();
            registry.config().commonTags(commonTags);
            Metrics.addRegistry((MeterRegistry)registry);
            if (jvmMetricsEnabled) {
                new ClassLoaderMetrics(commonTags).bindTo((MeterRegistry)Metrics.globalRegistry);
                new JvmMemoryMetrics(commonTags).bindTo((MeterRegistry)Metrics.globalRegistry);
                gc = new JvmGcMetrics(commonTags);
                gc.bindTo((MeterRegistry)Metrics.globalRegistry);
                new ProcessorMetrics(commonTags).bindTo((MeterRegistry)Metrics.globalRegistry);
                new JvmThreadMetrics(commonTags).bindTo((MeterRegistry)Metrics.globalRegistry);
            }
        }
    }

    public static void initializeProducers(MetricsProducer ... producer) {
        for (MetricsProducer p : producer) {
            p.registerMetrics((MeterRegistry)Metrics.globalRegistry);
            LOG.info("Metric producer {} initialize", (Object)p.getClass().getSimpleName());
        }
    }

    public static void addExecutorServiceMetrics(ExecutorService executor, String name) {
        new ExecutorServiceMetrics(executor, name, commonTags).bindTo((MeterRegistry)Metrics.globalRegistry);
    }

    public static List<Tag> getCommonTags() {
        return commonTags;
    }

    public static void close() {
        if (gc != null) {
            gc.close();
        }
    }
}

