/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import java.util.UUID;
import org.apache.accumulo.core.data.AbstractId;

public class ExternalCompactionId
extends AbstractId<ExternalCompactionId> {
    private static final String PREFIX = "ECID:";
    private static final long serialVersionUID = 1L;

    private ExternalCompactionId(UUID uuid) {
        super(PREFIX + uuid);
    }

    private ExternalCompactionId(String id) {
        super(id);
    }

    public static ExternalCompactionId generate(UUID uuid) {
        return new ExternalCompactionId(uuid);
    }

    public static ExternalCompactionId of(String id) {
        if (!id.startsWith(PREFIX)) {
            throw new IllegalArgumentException("Not a valid external compaction id " + id);
        }
        try {
            UUID.fromString(id.substring(PREFIX.length()));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Not a valid external compaction id " + id, e);
        }
        return new ExternalCompactionId(id);
    }

    public static ExternalCompactionId from(String ecid) {
        if (!((String)(ecid = ((String)ecid).replace(PREFIX.toLowerCase(), PREFIX))).startsWith(PREFIX)) {
            ecid = PREFIX + (String)ecid;
        }
        return ExternalCompactionId.of((String)ecid);
    }
}

