/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.lock;

import com.google.common.net.HostAndPort;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.LazySingletons;

public class ServiceLockData
implements Comparable<ServiceLockData> {
    private EnumMap<ThriftService, ServiceDescriptor> services = new EnumMap(ThriftService.class);

    public ServiceLockData(ServiceDescriptors sds) {
        sds.getServices().forEach(sd -> this.services.put(sd.getService(), (ServiceDescriptor)sd));
    }

    public ServiceLockData(UUID uuid, String address, ThriftService service, String group) {
        this(new ServiceDescriptors(new HashSet<ServiceDescriptor>(Collections.singleton(new ServiceDescriptor(uuid, service, address, group)))));
    }

    public ServiceLockData(UUID uuid, String address, ThriftService service) {
        this(new ServiceDescriptors(new HashSet<ServiceDescriptor>(Collections.singleton(new ServiceDescriptor(uuid, service, address)))));
    }

    public String getAddressString(ThriftService service) {
        ServiceDescriptor sd = this.services.get((Object)service);
        if (sd == null) {
            return null;
        }
        return sd.getAddress();
    }

    public HostAndPort getAddress(ThriftService service) {
        return AddressUtil.parseAddress(this.getAddressString(service), false);
    }

    public String getGroup(ThriftService service) {
        ServiceDescriptor sd = this.services.get((Object)service);
        if (sd == null) {
            return null;
        }
        return sd.getGroup();
    }

    public UUID getServerUUID(ThriftService service) {
        ServiceDescriptor sd = this.services.get((Object)service);
        if (sd == null) {
            return null;
        }
        return sd.getUUID();
    }

    public byte[] serialize() {
        ServiceDescriptors sd = new ServiceDescriptors();
        this.services.values().forEach(s -> sd.addService((ServiceDescriptor)s));
        return LazySingletons.GSON.get().toJson((Object)sd).getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        return new String(this.serialize(), StandardCharsets.UTF_8);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceLockData) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public int compareTo(ServiceLockData other) {
        return this.toString().compareTo(other.toString());
    }

    public static Optional<ServiceLockData> parse(byte[] lockData) {
        if (lockData == null) {
            return Optional.empty();
        }
        String data = new String(lockData, StandardCharsets.UTF_8);
        if (data.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(new ServiceLockData((ServiceDescriptors)LazySingletons.GSON.get().fromJson(data, ServiceDescriptors.class)));
    }

    public static class ServiceDescriptors {
        private final Set<ServiceDescriptor> descriptors;

        public ServiceDescriptors() {
            this.descriptors = new HashSet<ServiceDescriptor>();
        }

        public ServiceDescriptors(HashSet<ServiceDescriptor> descriptors) {
            this.descriptors = descriptors;
        }

        public void addService(ServiceDescriptor sd) {
            this.descriptors.add(sd);
        }

        public Set<ServiceDescriptor> getServices() {
            return this.descriptors;
        }
    }

    public static class ServiceDescriptor {
        public static final String DEFAULT_GROUP_NAME = "default";
        private final UUID uuid;
        private final ThriftService service;
        private final String address;
        private final String group;

        public ServiceDescriptor(UUID uuid, ThriftService service, String address) {
            this(uuid, service, address, DEFAULT_GROUP_NAME);
        }

        public ServiceDescriptor(UUID uuid, ThriftService service, String address, String group) {
            this.uuid = Objects.requireNonNull(uuid);
            this.service = Objects.requireNonNull(service);
            this.address = Objects.requireNonNull(address);
            this.group = Objects.requireNonNull(group);
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public ThriftService getService() {
            return this.service;
        }

        public String getAddress() {
            return this.address;
        }

        public String getGroup() {
            return this.group;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceDescriptor other = (ServiceDescriptor)obj;
            return this.toString().equals(other.toString());
        }

        public String toString() {
            return LazySingletons.GSON.get().toJson((Object)this);
        }
    }

    public static enum ThriftService {
        CLIENT,
        COORDINATOR,
        COMPACTOR,
        FATE,
        GC,
        MANAGER,
        NONE,
        TABLET_INGEST,
        TABLET_MANAGEMENT,
        TABLET_SCAN,
        TSERV;

    }
}

