/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.fate.Fate;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.ReadOnlyRepo;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.StackOverflowException;
import org.apache.accumulo.core.fate.TStore;
import org.apache.accumulo.core.fate.ZooStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgeOffStore<T>
implements TStore<T> {
    private static final Logger log = LoggerFactory.getLogger(AgeOffStore.class);
    private final ZooStore<T> store;
    private Map<Long, Long> candidates;
    private long ageOffTime;
    private long minTime;
    private TimeSource timeSource;

    private synchronized void updateMinTime() {
        this.minTime = Long.MAX_VALUE;
        for (Long time : this.candidates.values()) {
            if (time >= this.minTime) continue;
            this.minTime = time;
        }
    }

    private synchronized void addCandidate(long txid) {
        long time = this.timeSource.currentTimeMillis();
        this.candidates.put(txid, time);
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    private synchronized void removeCandidate(long txid) {
        Long time = this.candidates.remove(txid);
        if (time != null && time <= this.minTime) {
            this.updateMinTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void ageOff() {
        oldTxs = new HashSet<Long>();
        var2_2 = this;
        synchronized (var2_2) {
            time = this.timeSource.currentTimeMillis();
            if (this.minTime < time && time - this.minTime >= this.ageOffTime) {
                for (Map.Entry<Long, Long> entry : this.candidates.entrySet()) {
                    if (time - entry.getValue() < this.ageOffTime) continue;
                    oldTxs.add(entry.getKey());
                }
                this.candidates.keySet().removeAll(oldTxs);
                this.updateMinTime();
            }
        }
lbl18:
        // 5 sources

        block12: for (Long txid : oldTxs) {
            try {
                this.store.reserve(txid);
                try {
                    switch (1.$SwitchMap$org$apache$accumulo$core$fate$ReadOnlyTStore$TStatus[this.store.getStatus(txid).ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            this.store.delete(txid);
                            AgeOffStore.log.debug("Aged off FATE tx {}", (Object)FateTxId.formatTid(txid));
                            ** break;
                        }
                        ** default:
lbl28:
                        // 1 sources

                        continue block12;
                    }
                }
                finally {
                    this.store.unreserve(txid, 0L);
                }
            }
            catch (Exception e) {
                AgeOffStore.log.warn("Failed to age off FATE tx " + FateTxId.formatTid(txid), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public AgeOffStore(ZooStore<T> store, long ageOffTime, TimeSource timeSource) {
        super();
        this.store = store;
        this.ageOffTime = ageOffTime;
        this.timeSource = timeSource;
        this.candidates = new HashMap<Long, Long>();
        this.minTime = 0x7FFFFFFFFFFFFFFFL;
        txids = store.list();
lbl8:
        // 4 sources

        block6: for (Long txid : txids) {
            store.reserve(txid);
            try {
                switch (1.$SwitchMap$org$apache$accumulo$core$fate$ReadOnlyTStore$TStatus[store.getStatus(txid).ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.addCandidate(txid);
                        ** break;
                    }
                    ** default:
lbl16:
                    // 1 sources

                    continue block6;
                }
            }
            finally {
                store.unreserve(txid, 0L);
            }
        }
    }

    @Override
    public long create() {
        long txid = this.store.create();
        this.addCandidate(txid);
        return txid;
    }

    @Override
    public long reserve() {
        return this.store.reserve();
    }

    @Override
    public void reserve(long tid) {
        this.store.reserve(tid);
    }

    @Override
    public boolean tryReserve(long tid) {
        return this.store.tryReserve(tid);
    }

    @Override
    public void unreserve(long tid, long deferTime) {
        this.store.unreserve(tid, deferTime);
    }

    @Override
    public Repo<T> top(long tid) {
        return this.store.top(tid);
    }

    @Override
    public void push(long tid, Repo<T> repo) throws StackOverflowException {
        this.store.push(tid, repo);
    }

    @Override
    public void pop(long tid) {
        this.store.pop(tid);
    }

    @Override
    public ReadOnlyTStore.TStatus getStatus(long tid) {
        return this.store.getStatus(tid);
    }

    @Override
    public void setStatus(long tid, ReadOnlyTStore.TStatus status) {
        this.store.setStatus(tid, status);
        switch (status) {
            case SUBMITTED: 
            case IN_PROGRESS: 
            case FAILED_IN_PROGRESS: {
                this.removeCandidate(tid);
                break;
            }
            case FAILED: 
            case SUCCESSFUL: {
                this.addCandidate(tid);
                break;
            }
        }
    }

    @Override
    public ReadOnlyTStore.TStatus waitForStatusChange(long tid, EnumSet<ReadOnlyTStore.TStatus> expected) {
        return this.store.waitForStatusChange(tid, expected);
    }

    @Override
    public void setTransactionInfo(long tid, Fate.TxInfo txInfo, Serializable val) {
        this.store.setTransactionInfo(tid, txInfo, val);
    }

    @Override
    public Serializable getTransactionInfo(long tid, Fate.TxInfo txInfo) {
        return this.store.getTransactionInfo(tid, txInfo);
    }

    @Override
    public void delete(long tid) {
        this.store.delete(tid);
        this.removeCandidate(tid);
    }

    @Override
    public List<Long> list() {
        return this.store.list();
    }

    @Override
    public long timeCreated(long tid) {
        return this.store.timeCreated(tid);
    }

    @Override
    public List<ReadOnlyRepo<T>> getStack(long tid) {
        return this.store.getStack(tid);
    }

    public static interface TimeSource {
        public long currentTimeMillis();
    }
}

