/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.net.URL;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.hadoop.conf.Configuration;

public interface ClientInfo {
    public String getInstanceName();

    public String getZooKeepers();

    public int getZooKeepersSessionTimeOut();

    public String getPrincipal();

    public AuthenticationToken getAuthenticationToken();

    public boolean saslEnabled();

    public Properties getProperties();

    public Configuration getHadoopConf();

    public static ClientInfo from(Properties properties) {
        return new ClientInfoImpl(properties);
    }

    public static ClientInfo from(URL propertiesURL) {
        return new ClientInfoImpl(propertiesURL);
    }

    public static ClientInfo from(Properties properties, AuthenticationToken token) {
        return new ClientInfoImpl(properties, token);
    }

    public static ClientInfo from(Path propertiesFile) {
        return new ClientInfoImpl(propertiesFile);
    }
}

